/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.driver.TbTimeoutPollingThread;
import java.sql.SQLException;

public class TbTimeout {
    private static final long INFINITE_TIME = Long.MAX_VALUE;
    private static final TbTimeoutPollingThread pollingThread = new TbTimeoutPollingThread();
    private TbStatement stmt;
    private long interruptAfter = Long.MAX_VALUE;

    static TbTimeout newTimeout() throws SQLException {
        TbTimeout tbTimeout = new TbTimeout();
        return tbTimeout;
    }

    TbTimeout() {
        pollingThread.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStmtOfTimeover(long l) {
        if (l > this.interruptAfter) {
            TbTimeout tbTimeout = this;
            synchronized (tbTimeout) {
                if (l > this.interruptAfter) {
                    try {
                        this.stmt.cancel();
                        this.stmt = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    synchronized void cancelTimeout() throws SQLException {
        this.stmt = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    void close() {
        pollingThread.remove(this);
    }

    synchronized void setTimeout(long l, TbStatement tbStatement) throws SQLException {
        this.stmt = tbStatement;
        this.interruptAfter = System.currentTimeMillis() + l;
    }
}

