/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.ParseException;
import com.tmax.tibero.jdbc.util.TbUrlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class TbDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 6545162651851145814L;
    private TbDriver driver = null;
    protected ConnectionInfo info = new ConnectionInfo();
    private boolean isExplicitURL = false;
    private int maxStatements = 0;
    private int initialPoolSize = 0;
    private int minPoolSize = 0;
    private int maxPoolSize = 0;
    private int maxIdleTime = 0;
    private int propertyCycle = 0;
    private int loginTimeout = 0;
    private Properties connectionProperties;
    private String connectionConfigFilePath = this.getTbHomeConfigPath() + "TbJDBCConnection.properties";
    private static boolean reloadConfig;
    private static long lastModifiedTime;

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String string, String string2) throws SQLException {
        if (reloadConfig) {
            this.reloadConnectionConfigFile(this.getConnectionConfigFile());
        }
        Wrapper wrapper = this;
        synchronized (wrapper) {
            if (string != null) {
                this.info.setUser(string);
            }
            if (string2 != null) {
                this.info.setPassword(string2);
            }
        }
        if (this.loginTimeout != 0) {
            this.info.setLoginTimeout(this.loginTimeout);
        }
        if (this.driver == null) {
            this.driver = new TbDriver();
        }
        if (!this.isExplicitURL) {
            this.info.setURL(TbUrlParser.makeURL(this.info));
        }
        wrapper = this.driver.connect(this.info);
        return wrapper;
    }

    public synchronized String getDatabaseName() {
        return this.info.getDatabaseName();
    }

    public synchronized String getDataSourceName() {
        return this.info.getDataSourceName();
    }

    public synchronized String getDescription() {
        return this.info.getDescription();
    }

    public synchronized String getDriverType() {
        return this.info.getDriverType();
    }

    public synchronized int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public synchronized int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public synchronized PrintWriter getLogWriter() throws SQLException {
        return Debug.getLogWriter();
    }

    public synchronized int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized int getMaxStatements() {
        return this.maxStatements;
    }

    public synchronized int getMinPoolSize() {
        return this.minPoolSize;
    }

    public synchronized String getNetworkProtocol() {
        return this.info.getNetworkProtocol();
    }

    public synchronized boolean getNlsDatetimeFormatEnabled() {
        return this.info.getNlsDatetimeFormatEnabled();
    }

    public synchronized String getPassword() {
        return this.info.getPassword();
    }

    public synchronized int getPortNumber() {
        if (this.info.getNodeList() != null && this.info.getNodeList().size() == 1) {
            NodeInfo nodeInfo = (NodeInfo)this.info.getNodeList().get(0);
            return nodeInfo.getPort();
        }
        return 8629;
    }

    public synchronized String getProgramName() {
        return this.info.getProgramName();
    }

    public synchronized int getPropertyCycle() {
        return this.propertyCycle;
    }

    public synchronized int getReadTimeout() {
        return this.info.getReadTimeout();
    }

    public synchronized Reference getReference() throws NamingException {
        String string;
        String string2;
        int n;
        int n2;
        String string3;
        String string4;
        Object object;
        String string5;
        String string6;
        String string7;
        Reference reference = new Reference(this.getClass().getName(), "com.tmax.tibero.jdbc.ext.TbDataSourceFactory", null);
        String string8 = this.info.getUser();
        if (string8 != null) {
            reference.add(new StringRefAddr("user", string8));
        }
        if ((string7 = this.info.getPassword()) != null) {
            reference.add(new StringRefAddr("password", string7));
        }
        if ((string6 = this.info.getURL()) != null && !string6.equals("")) {
            reference.add(new StringRefAddr("url", string6));
        }
        if ((string5 = this.info.getNetworkProtocol()) != null && !string5.equals("")) {
            reference.add(new StringRefAddr("networkProtocol", string5));
        }
        int n3 = 8629;
        String string9 = null;
        if (this.info.getNodeList().size() == 1) {
            object = (NodeInfo)this.info.getNodeList().get(0);
            string9 = ((NodeInfo)object).getAddress();
            n3 = ((NodeInfo)object).getPort();
        }
        if (string9 != null && !string9.equals("")) {
            reference.add(new StringRefAddr("serverName", string9));
        }
        reference.add(new StringRefAddr("tdu", Integer.toString(this.info.getTDU())));
        reference.add(new StringRefAddr("portNumber", Integer.toString(n3)));
        object = this.info.getDatabaseName();
        if (object != null && !((String)object).equals("")) {
            reference.add(new StringRefAddr("databaseName", this.info.getDatabaseName()));
        }
        if ((string4 = this.info.getDescription()) != null && !string4.equals("")) {
            reference.add(new StringRefAddr("description", string4));
        }
        if ((string3 = this.info.getDataSourceName()) != null && !string3.equals("")) {
            reference.add(new StringRefAddr("dataSourceName", string3));
        }
        if ((n2 = this.info.getLoginTimeout()) > 0) {
            reference.add(new StringRefAddr("login_timeout", String.valueOf(n2)));
        }
        if ((n = this.info.getLoginTimeout()) > 0) {
            reference.add(new StringRefAddr("read_timeout", String.valueOf(n)));
        }
        if ((string2 = this.info.getProgramName()) != null && !string2.equals("")) {
            reference.add(new StringRefAddr("program_name", string2));
        }
        switch (this.info.getFailover()) {
            case 1: {
                string = "SESSION";
                break;
            }
            case 3: {
                string = "CURSOR";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        reference.add(new StringRefAddr("failover", string));
        reference.add(new StringRefAddr("load_balance", String.valueOf(this.info.isLoadBalance())));
        reference.add(new StringRefAddr("failover_retry_count", Integer.toString(this.info.getFailoverRetryCount())));
        String string10 = this.info.getCharacterSet();
        if (string10 != null && !string10.equals("")) {
            reference.add(new StringRefAddr("characterset", string10));
        }
        reference.add(new StringRefAddr("statement_cache", String.valueOf(this.info.isStmtCache())));
        reference.add(new StringRefAddr("statement_cache_max_size", Integer.toString(this.info.getStmtCacheMaxSize())));
        reference.add(new StringRefAddr("lobChunkMaxSize", Integer.toString(this.info.getLobMaxChunkSize())));
        reference.add(new StringRefAddr("includeSynonyms", String.valueOf(this.info.getIncludeSynonyms())));
        reference.add(new StringRefAddr("mapDateToTimestamp", String.valueOf(this.info.getMapDateToTimestamp())));
        reference.add(new StringRefAddr("defaultNChar", String.valueOf(this.info.getDefaultNChar())));
        boolean bl = this.info.useSelfKeepAlive();
        reference.add(new StringRefAddr("self_keepalive", String.valueOf(bl)));
        if (bl) {
            reference.add(new StringRefAddr("self_keepidle", Integer.toString(this.info.getSelfKeepIdle())));
            reference.add(new StringRefAddr("self_keepintvl", Integer.toString(this.info.getSelfKeepInterval())));
            reference.add(new StringRefAddr("self_keepcnt", Integer.toString(this.info.getSelfKeepCount())));
        }
        reference.add(new StringRefAddr("nls_datetime_format_enabled", String.valueOf(this.info.getNlsDatetimeFormatEnabled())));
        return reference;
    }

    public synchronized String getRoleName() {
        return "";
    }

    public synchronized String getServerName() {
        if (this.info.getNodeList() != null && this.info.getNodeList().size() == 1) {
            NodeInfo nodeInfo = (NodeInfo)this.info.getNodeList().get(0);
            return nodeInfo.getAddress();
        }
        return "localhost";
    }

    public synchronized boolean getSelfKeepalive() {
        return this.info.useSelfKeepAlive();
    }

    public synchronized int getSelfKeepcnt() {
        return this.info.getSelfKeepCount();
    }

    public synchronized int getSelfKeepidle() {
        return this.info.getSelfKeepIdle();
    }

    public synchronized int getSelfKeepintvl() {
        return this.info.getSelfKeepInterval();
    }

    public synchronized int getTdu() {
        return this.info.getTDU();
    }

    public synchronized String getURL() throws SQLException {
        if (!this.isExplicitURL) {
            this.info.setURL(TbUrlParser.makeURL(this.info));
        }
        return this.info.getURL();
    }

    public synchronized String getUser() {
        return this.info.getUser();
    }

    public synchronized void setDatabaseName(String string) {
        this.info.setDatabaseName(string);
    }

    public synchronized void setDataSourceName(String string) {
        this.info.setDataSourceName(string);
    }

    public synchronized void setDescription(String string) {
        this.info.setDescription(string);
    }

    public synchronized void setDriverType(String string) {
        this.info.setDriverType(string);
    }

    public synchronized void setInitialPoolSize(int n) {
        this.initialPoolSize = n;
    }

    public synchronized void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws SQLException {
        Debug.setLogWriter(printWriter);
    }

    public synchronized void setMaxIdleTime(int n) {
        this.maxIdleTime = n;
    }

    public synchronized void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public synchronized void setMaxStatements(int n) {
        this.maxStatements = n;
    }

    public synchronized void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    public synchronized void setNetworkProtocol(String string) {
        this.info.setNetworkProtocol(string);
    }

    public synchronized void setNlsDatetimeFormatEnabled(boolean bl) {
        this.info.setNlsDatetimeFormatEnabled(bl);
    }

    public synchronized void setPassword(String string) {
        this.info.setPassword(string);
    }

    public synchronized void setPortNumber(int n) {
        if (this.info.getNodeList() == null) {
            Vector<NodeInfo> vector = new Vector<NodeInfo>();
            NodeInfo nodeInfo = new NodeInfo();
            nodeInfo.setPort(n);
            vector.add(nodeInfo);
            this.info.setNodeList(vector);
        } else {
            NodeInfo nodeInfo = (NodeInfo)this.info.getNodeList().get(0);
            nodeInfo.setPort(n);
        }
    }

    public synchronized void setProgramName(String string) {
        this.info.setProgramName(string);
    }

    public synchronized void setPropertyCycle(int n) {
        this.propertyCycle = n;
    }

    public synchronized void setReadTimeout(int n) {
        this.info.setReadTimeout(n);
    }

    public synchronized void setRoleName(String string) {
    }

    public synchronized void setSelfKeepalive(String string) throws SQLException {
        try {
            this.info.setSelfKeepAlive("true".equalsIgnoreCase(string));
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + string + "\" to boolean");
        }
    }

    public synchronized void setSelfKeepalive(boolean bl) {
        this.info.setSelfKeepAlive(bl);
    }

    public synchronized void setSelfKeepidle(String string) throws SQLException {
        try {
            this.info.setSelfKeepIdle(Integer.parseInt(string));
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + string + "\" to integer");
        }
    }

    public synchronized void setSelfKeepidle(int n) {
        this.info.setSelfKeepIdle(n);
    }

    public synchronized void setSelfKeepintvl(String string) throws SQLException {
        try {
            this.info.setSelfKeepInterval(Integer.parseInt(string));
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + string + "\" to integer");
        }
    }

    public synchronized void setSelfKeepintvl(int n) {
        this.info.setSelfKeepInterval(n);
    }

    public synchronized void setSelfKeepcnt(String string) throws SQLException {
        try {
            this.info.setSelfKeepCount(Integer.parseInt(string));
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + string + "\" to integer");
        }
    }

    public synchronized void setSelfKeepcnt(int n) {
        this.info.setSelfKeepCount(n);
    }

    public synchronized void setServerName(String string) {
        if (this.info.getNodeList() == null) {
            Vector<NodeInfo> vector = new Vector<NodeInfo>();
            NodeInfo nodeInfo = new NodeInfo();
            nodeInfo.setAddress(string);
            vector.add(nodeInfo);
            this.info.setNodeList(vector);
        } else {
            NodeInfo nodeInfo = (NodeInfo)this.info.getNodeList().get(0);
            nodeInfo.setAddress(string);
        }
    }

    public synchronized void setTdu(int n) {
        this.info.setTDU(n);
    }

    public synchronized void setURL(String string) throws SQLException {
        ConnectionInfo connectionInfo;
        try {
            connectionInfo = TbUrlParser.parseUrl(string, null);
        }
        catch (ParseException parseException) {
            throw TbError.newSQLException(-90605);
        }
        if (connectionInfo == null) {
            throw TbError.newSQLException(-90605);
        }
        this.info.setURL(string);
        this.info.setDriverType(connectionInfo.getDriverType());
        this.info.setNodeList(connectionInfo.getNodeList());
        this.info.setDatabaseName(connectionInfo.getDatabaseName());
        this.info.setFailover(connectionInfo.getFailover());
        this.info.setLoadBalance(connectionInfo.isLoadBalance());
        this.info.setNetworkProtocol(connectionInfo.getNetworkProtocol());
        connectionInfo = null;
        this.isExplicitURL = true;
    }

    public synchronized void setUser(String string) {
        this.info.setUser(string);
    }

    private String getTbHomeConfigPath() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            string = System.getenv("TB_HOME");
            if (string != null && !string.equals("")) {
                stringBuffer.append(string);
                if (!stringBuffer.toString().endsWith(File.separator)) {
                    stringBuffer.append(File.separator);
                }
                return stringBuffer.append("client").append(File.separator).append("config").append(File.separator).toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = System.getProperty("TB_HOME");
        if (string != null && !string.equals("")) {
            stringBuffer.append(string);
            if (!stringBuffer.toString().endsWith(File.separator)) {
                stringBuffer.append(File.separator);
            }
            return stringBuffer.append("client").append(File.separator).append("config").append(File.separator).toString();
        }
        return stringBuffer.toString();
    }

    public void setConnectionConfigFile(String string) throws SQLException {
        File file;
        if (string == null || string.equals("")) {
            file = new File(this.connectionConfigFilePath);
        } else {
            file = new File(string);
            this.connectionConfigFilePath = string;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(new BufferedInputStream(fileInputStream));
            this.setConfigProperties(properties);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-590707, iOException.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setConfigProperties(Properties properties) throws SQLException {
        int n;
        String string;
        String string2;
        String string3;
        reloadConfig = properties.getProperty("reload_config", "false").equalsIgnoreCase("yes");
        String string4 = this.getUser();
        if (string4 != null && !string4.equals("")) {
            properties.put("user", string4);
        }
        if ((string3 = this.getPassword()) != null && !string3.equals("")) {
            properties.put("password", string3);
        }
        if ((string2 = this.info.getURL()) != null && !string2.equals("")) {
            properties.put("url", string2);
        }
        if ((string = this.getServerName()) != null && !string.equals("localhost")) {
            properties.put("serverName", string);
        }
        if ((n = this.getPortNumber()) != 8629) {
            properties.put("portNumber", String.valueOf(n));
        }
        this.info.set(properties);
        string2 = properties.getProperty("url");
        if (string2 != null && !string2.equals("")) {
            this.setURL(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConnectionConfigFile(String string) throws SQLException {
        File file = null;
        FileInputStream fileInputStream = null;
        Properties properties = null;
        try {
            file = new File(string);
            long l = file.lastModified();
            if (lastModifiedTime >= l) {
                return;
            }
            properties = new Properties();
            fileInputStream = new FileInputStream(file);
            properties.load(new BufferedInputStream(fileInputStream));
            this.info.update(properties);
            String string2 = properties.getProperty("url");
            if (string2 != null && !string2.equals("")) {
                this.setURL(string2);
            }
            lastModifiedTime = l;
        }
        catch (IOException iOException) {
            TbError.newSQLException(-590700, string);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getConnectionConfigFile() {
        return this.connectionConfigFilePath;
    }

    public void setConnectionProperties(Properties properties) {
        ConnectionInfo connectionInfo = new ConnectionInfo(properties);
        if (properties.containsKey("driverType")) {
            this.info.setDriverType(connectionInfo.getDriverType());
        }
        if (properties.containsKey("serverName")) {
            this.info.setNodeList(connectionInfo.getNodeList());
        }
        if (properties.containsKey("databaseName")) {
            this.info.setDatabaseName(connectionInfo.getDatabaseName());
        }
        if (properties.containsKey("failover")) {
            this.info.setFailover(connectionInfo.getFailover());
        }
        if (properties.containsKey("failover_retry_count")) {
            this.info.setFailoverRetryCount(connectionInfo.getFailoverRetryCount());
        }
        if (properties.containsKey("load_balance")) {
            this.info.setLoadBalance(connectionInfo.isLoadBalance());
        }
        if (properties.containsKey("networkProtocol")) {
            this.info.setNetworkProtocol(connectionInfo.getNetworkProtocol());
        }
        if (properties.containsKey("description")) {
            this.info.setDescription(connectionInfo.getDescription());
        }
        if (properties.containsKey("user")) {
            this.info.setUser(connectionInfo.getUser(), false);
        }
        if (properties.containsKey("password")) {
            this.info.setPassword(connectionInfo.getPassword());
        }
        if (properties.containsKey("url")) {
            this.info.setURL(connectionInfo.getURL());
        }
        if (properties.containsKey("login_timeout")) {
            this.info.setLoginTimeout(connectionInfo.getLoginTimeout());
        }
        if (properties.containsKey("read_timeout")) {
            this.info.setReadTimeout(connectionInfo.getReadTimeout());
        }
        if (properties.containsKey("statement_cache")) {
            this.info.setStmtCache(connectionInfo.isStmtCache());
        }
        if (properties.containsKey("statement_cache_max_size")) {
            this.info.setStmtCacheMaxSize(connectionInfo.getStmtCacheMaxSize());
        }
        if (properties.containsKey("program_name")) {
            this.info.setProgramName(connectionInfo.getProgramName());
        }
        if (properties.containsKey("characterset")) {
            this.info.setCharacterSet(connectionInfo.getCharacterSet());
        }
        if (properties.containsKey("includeSynonyms")) {
            this.info.setIncludeSynonyms(connectionInfo.getIncludeSynonyms());
        }
        if (properties.containsKey("mapDateToTimestamp")) {
            this.info.setMapDateToTimestamp(connectionInfo.getMapDateToTimestamp());
        }
        if (properties.containsKey("defaultNChar")) {
            this.info.setDefaultNChar(connectionInfo.getDefaultNChar());
        }
        if (properties.containsKey("databaseProductName")) {
            this.info.setDatabaseProductName(connectionInfo.getDatabaseProductName());
        }
        if (properties.containsKey("databaseProductVersion")) {
            this.info.setDatabaseProductVersion(connectionInfo.getDatabaseProductVersion());
        }
        if (properties.containsKey("driverName")) {
            this.info.setDriverName(connectionInfo.getDriverName());
        }
        if (properties.containsKey("driverVersion")) {
            this.info.setDriverVersion(connectionInfo.getDriverVersion());
        }
        if (properties.containsKey("lobChunkMaxSize")) {
            this.info.setLobMaxChunkSize(connectionInfo.getLobMaxChunkSize());
        }
        if (properties.containsKey("self_keepalive")) {
            this.info.setSelfKeepAlive(connectionInfo.useSelfKeepAlive());
        }
        if (properties.containsKey("self_keepidle")) {
            this.info.setSelfKeepIdle(connectionInfo.getSelfKeepIdle());
        }
        if (properties.containsKey("self_keepintvl")) {
            this.info.setSelfKeepInterval(connectionInfo.getSelfKeepInterval());
        }
        if (properties.containsKey("self_keepcnt")) {
            this.info.setSelfKeepCount(connectionInfo.getSelfKeepCount());
        }
        if (properties.containsKey("nls_datetime_format_enabled")) {
            this.info.setNlsDatetimeFormatEnabled(connectionInfo.getNlsDatetimeFormatEnabled());
        }
        this.connectionProperties = properties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }
}

