/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;

public abstract class QNameUtils {
    @Deprecated
    public static QName createQName(String namespaceUri, String localPart, String prefix) {
        return new QName(namespaceUri, localPart, prefix);
    }

    @Deprecated
    public static String getPrefix(QName qName) {
        return qName.getPrefix();
    }

    public static boolean validateQName(String text) {
        int i;
        if (!StringUtils.hasLength((String)text)) {
            return false;
        }
        return text.charAt(0) != '{' || (i = text.indexOf(125)) != -1 && i != text.length() - 1;
    }

    public static QName getQNameForNode(Node node) {
        if (node.getNamespaceURI() != null && node.getPrefix() != null && node.getLocalName() != null) {
            return new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
        }
        if (node.getNamespaceURI() != null && node.getLocalName() != null) {
            return new QName(node.getNamespaceURI(), node.getLocalName());
        }
        if (node.getLocalName() != null) {
            return new QName(node.getLocalName());
        }
        return new QName(node.getNodeName());
    }

    public static String toQualifiedName(QName qName) {
        String prefix = qName.getPrefix();
        if (!StringUtils.hasLength((String)prefix)) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    public static QName toQName(String namespaceUri, String qualifiedName) {
        int idx = qualifiedName.indexOf(58);
        if (idx == -1) {
            return new QName(namespaceUri, qualifiedName);
        }
        return new QName(namespaceUri, qualifiedName.substring(idx + 1), qualifiedName.substring(0, idx));
    }

    public static QName parseQNameString(String qNameString) {
        Assert.hasLength((String)qNameString, (String)"QName text may not be null or empty");
        if (qNameString.charAt(0) != '{') {
            return new QName(qNameString);
        }
        int endOfNamespaceURI = qNameString.indexOf(125);
        if (endOfNamespaceURI == -1) {
            throw new IllegalArgumentException("Cannot create QName from \"" + qNameString + "\", missing closing \"}\"");
        }
        int prefixSeperator = qNameString.indexOf(58, endOfNamespaceURI + 1);
        String namespaceURI = qNameString.substring(1, endOfNamespaceURI);
        if (prefixSeperator == -1) {
            return new QName(namespaceURI, qNameString.substring(endOfNamespaceURI + 1));
        }
        return new QName(namespaceURI, qNameString.substring(prefixSeperator + 1), qNameString.substring(endOfNamespaceURI + 1, prefixSeperator));
    }
}

