/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class UTF8CharToByteConverter {
    protected boolean subMode;
    protected byte[] subBytes = new byte[]{63};

    public boolean canConvert(char c) {
        return true;
    }

    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        byte[] byArray2 = new byte[6];
        n6 = n;
        n7 = n3;
        if (n8 != 0) {
            n8 = 0;
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                n5 = (n8 - 55296) * 1024 + (cArray[n] - 56320) + 65536;
                byArray[0] = (byte)(0xF0 | n5 >> 18 & 7);
                byArray[1] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[2] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[3] = (byte)(0x80 | n5 & 0x3F);
                ++n6;
                n8 = 0;
            } else {
                throw TbError.newSQLException(-590742, (int)cArray[n]);
            }
        }
        while (n6 < n2) {
            int n9;
            int n10;
            int n11 = cArray[n6];
            if (n11 < 128) {
                byArray2[0] = (byte)n11;
                n5 = 1;
                n10 = 1;
            } else if (n11 < 2048) {
                byArray2[0] = (byte)(0xC0 | n11 >> 6 & 0x1F);
                byArray2[1] = (byte)(0x80 | n11 & 0x3F);
                n5 = 1;
                n10 = 2;
            } else if (n11 >= 55296 && n11 <= 56319) {
                if (n6 + 1 >= n2) {
                    n8 = n11;
                    break;
                }
                n9 = cArray[n6 + 1];
                if (n9 < 56320 || n9 > 57343) {
                    throw TbError.newSQLException(-590742, n9);
                }
                int n12 = (n11 - 55296) * 1024 + (n9 - 56320) + 65536;
                byArray2[0] = (byte)(0xF0 | n12 >> 18 & 7);
                byArray2[1] = (byte)(0x80 | n12 >> 12 & 0x3F);
                byArray2[2] = (byte)(0x80 | n12 >> 6 & 0x3F);
                byArray2[3] = (byte)(0x80 | n12 & 0x3F);
                n10 = 4;
                n5 = 2;
            } else {
                byArray2[0] = (byte)(0xE0 | n11 >> 12 & 0xF);
                byArray2[1] = (byte)(0x80 | n11 >> 6 & 0x3F);
                byArray2[2] = (byte)(0x80 | n11 & 0x3F);
                n5 = 1;
                n10 = 3;
            }
            if (n7 + n10 > n4) {
                throw TbError.newSQLException(-590744, n7 + " + " + n10 + " > " + n4);
            }
            for (n9 = 0; n9 < n10; ++n9) {
                byArray[n7++] = byArray2[n9];
            }
            n6 += n5;
        }
        return n7 - n3;
    }

    public int convString(String string, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        byte[] byArray2 = new byte[6];
        n6 = n;
        n7 = n3;
        if (n8 != 0) {
            n8 = 0;
            if (string.charAt(n) >= '\udc00' && string.charAt(n) <= '\udfff') {
                n5 = (n8 - 55296) * 1024 + (string.charAt(n) - 56320) + 65536;
                byArray[0] = (byte)(0xF0 | n5 >> 18 & 7);
                byArray[1] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[2] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[3] = (byte)(0x80 | n5 & 0x3F);
                ++n6;
                n8 = 0;
            } else {
                throw TbError.newSQLException(-590742, (int)string.charAt(n));
            }
        }
        while (n6 < n2) {
            int n9;
            int n10;
            char c = string.charAt(n6);
            if (c < '\u0080') {
                byArray2[0] = (byte)c;
                n5 = 1;
                n10 = 1;
            } else if (c < '\u0800') {
                byArray2[0] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray2[1] = (byte)(0x80 | c & 0x3F);
                n5 = 1;
                n10 = 2;
            } else if (c >= '\ud800' && c <= '\udbff') {
                if (n6 + 1 >= n2) {
                    n8 = c;
                    break;
                }
                n9 = string.charAt(n6 + 1);
                if (n9 < 56320 || n9 > 57343) {
                    throw TbError.newSQLException(-590742, n9);
                }
                int n11 = (c - 55296) * 1024 + (n9 - 56320) + 65536;
                byArray2[0] = (byte)(0xF0 | n11 >> 18 & 7);
                byArray2[1] = (byte)(0x80 | n11 >> 12 & 0x3F);
                byArray2[2] = (byte)(0x80 | n11 >> 6 & 0x3F);
                byArray2[3] = (byte)(0x80 | n11 & 0x3F);
                n10 = 4;
                n5 = 2;
            } else {
                byArray2[0] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray2[1] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray2[2] = (byte)(0x80 | c & 0x3F);
                n5 = 1;
                n10 = 3;
            }
            if (n7 + n10 > n4) {
                throw TbError.newSQLException(-590744, n7 + " + " + n10 + " > " + n4);
            }
            for (n9 = 0; n9 < n10; ++n9) {
                byArray[n7++] = byArray2[n9];
            }
            n6 += n5;
        }
        return n7 - n3;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }
}

