/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;

public class TbCachedRowSetReader
implements RowSetReader,
Serializable {
    private static final long serialVersionUID = 3627327166239927438L;
    private static boolean isInitializedDriver = false;

    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection = rowSetInternal.getConnection();
        String string = ((RowSet)((Object)rowSetInternal)).getUrl();
        String string2 = ((RowSet)((Object)rowSetInternal)).getUsername();
        String string3 = ((RowSet)((Object)rowSetInternal)).getPassword();
        String string4 = ((RowSet)((Object)rowSetInternal)).getDataSourceName();
        if (connection != null && !connection.isClosed()) {
            return connection;
        }
        if (string4 != null && !string4.equals("")) {
            try {
                Object object;
                InitialContext initialContext = null;
                try {
                    object = System.getProperties();
                    initialContext = new InitialContext((Hashtable<?, ?>)object);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (initialContext == null) {
                    initialContext = new InitialContext();
                }
                object = (DataSource)initialContext.lookup(string4);
                if (string2 == null && string3 == null) {
                    return object.getConnection();
                }
                return object.getConnection(string2, string3);
            }
            catch (NamingException namingException) {
                throw TbError.newSQLException(-90828, namingException.getMessage());
            }
        }
        if (string != null && !string.equals("")) {
            if (!isInitializedDriver) {
                DriverManager.registerDriver(new TbDriver());
                isInitializedDriver = true;
            }
            if (string2.equals("") || string3.equals("")) {
                throw TbError.newSQLException(-90854);
            }
            return DriverManager.getConnection(string, string2, string3);
        }
        throw TbError.newSQLException(-90852);
    }

    public synchronized void readData(RowSetInternal rowSetInternal) throws SQLException {
        TbCachedRowSet tbCachedRowSet = (TbCachedRowSet)rowSetInternal;
        Connection connection = this.getConnection(rowSetInternal);
        if (tbCachedRowSet.getCommand() == null) {
            throw TbError.newSQLException(-90826);
        }
        try {
            connection.setTransactionIsolation(tbCachedRowSet.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement preparedStatement = connection.prepareStatement(tbCachedRowSet.getCommand());
        this.setParams(rowSetInternal.getParams(), preparedStatement);
        try {
            preparedStatement.setMaxRows(tbCachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(tbCachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(tbCachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(tbCachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        tbCachedRowSet.populate(resultSet);
        resultSet.close();
        preparedStatement.close();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!tbCachedRowSet.isConnectionOpened()) {
            connection.close();
        }
    }

    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Object[])) {
                preparedStatement.setObject(i + 1, objectArray[i]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i];
            if (objectArray2.length == 2) {
                this.setParams2Arg(i, objectArray2, preparedStatement);
                continue;
            }
            if (objectArray2.length != 3) continue;
            this.setParams3Arg(i, objectArray2, preparedStatement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams2Arg(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        if (objectArray[0] == null) {
            preparedStatement.setNull(n + 1, (Integer)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Date) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setDate(n + 1, (Date)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Time) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setTime(n + 1, (Time)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Timestamp) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setTimestamp(n + 1, (Timestamp)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Reader) {
            preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Integer)objectArray[1]);
            return;
        } else {
            if (!(objectArray[1] instanceof Integer)) return;
            preparedStatement.setObject(n + 1, objectArray[0], (Integer)objectArray[1]);
        }
    }

    private void setParams3Arg(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (objectArray[0] != null) break block11;
                        preparedStatement.setNull(n + 1, (Integer)objectArray[1], (String)objectArray[2]);
                        break block12;
                    }
                    if (!(objectArray[0] instanceof Reader)) break block13;
                    switch ((Integer)objectArray[2]) {
                        case 3: {
                            if (objectArray[1] instanceof Integer) {
                                preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Integer)objectArray[1]);
                            }
                            break block12;
                        }
                        default: {
                            throw TbError.newSQLException(-90846, ((Integer)objectArray[2]).toString());
                        }
                    }
                }
                if (!(objectArray[0] instanceof InputStream)) break block14;
                switch ((Integer)objectArray[2]) {
                    case 2: {
                        if (objectArray[1] instanceof Integer) {
                            preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray[0], (Integer)objectArray[1]);
                        }
                        break block12;
                    }
                    case 1: {
                        preparedStatement.setAsciiStream(n + 1, (InputStream)objectArray[0], (Integer)objectArray[1]);
                        break block12;
                    }
                    default: {
                        throw TbError.newSQLException(-90846, ((Integer)objectArray[2]).toString());
                    }
                }
            }
            if (objectArray[1] instanceof Integer && objectArray[2] instanceof Integer) {
                preparedStatement.setObject(n + 1, objectArray[0], (Integer)objectArray[1], (int)((Integer)objectArray[2]));
            } else {
                throw TbError.newSQLException(-90846, objectArray[0].toString());
            }
        }
    }
}

