/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class TbCallableStatementImpl
extends TbPreparedStatementImpl
implements CallableStatement {
    private static final int DFLT_NAMED_PARAM_CNT = 10;
    private static final int OID_BYTE_LENGTH = 32;
    private static final int TOBJID_BYTE_LENGTH = 4;
    private static final int VERSION_NO_BYTE_LENGTH = 4;
    private String[] namedParamArr = new String[10];
    private int namedParamCnt;
    private boolean haveNamedParameter;
    private boolean haveOrdinalParameter;
    private boolean lastColumnWasNull;
    private byte[][] outParamBytes = new byte[this.bindParamCnt][];
    private byte[] outParamTypes = new byte[this.bindParamCnt];
    private TbResultSet[] outPrefetchedRs = new TbResultSet[this.bindParamCnt];
    private BindItem[] outItems = new BindItem[this.bindParamCnt];
    protected TbPivotInfo[][] pivotInfoArr;
    protected ArrayList pivotDataArr;

    public TbCallableStatementImpl(TbConnection tbConnection, String string) throws SQLException {
        this(tbConnection, string, 1003, 1007, 64000);
    }

    public TbCallableStatementImpl(TbConnection tbConnection, String string, int n, int n2, int n3) throws SQLException {
        super(tbConnection, string, n, n2, n3, false);
        for (int i = 0; i < this.bindParamCnt; ++i) {
            this.outItems[i] = new BindItem();
        }
    }

    private int addNamedParam(String string) {
        for (int i = 0; i < this.namedParamCnt; ++i) {
            if (!this.namedParamArr[i].equals(string)) continue;
            return i + 1;
        }
        if (this.namedParamCnt >= this.namedParamArr.length) {
            String[] stringArray = new String[this.namedParamArr.length * 2];
            System.arraycopy(this.namedParamArr, 0, stringArray, 0, this.namedParamArr.length);
            this.namedParamArr = stringArray;
        }
        this.namedParamArr[this.namedParamCnt++] = string;
        this.haveNamedParameter = true;
        return this.namedParamCnt;
    }

    public void addPivotData(int n, byte[] byArray) {
        Vector<byte[]> vector;
        if (this.pivotDataArr == null) {
            this.pivotDataArr = new ArrayList(this.bindParamCnt);
            for (int i = 0; i < this.bindParamCnt; ++i) {
                this.pivotDataArr.add(null);
            }
        }
        if ((vector = (Vector<byte[]>)this.pivotDataArr.get(n)) == null) {
            vector = new Vector<byte[]>();
            this.pivotDataArr.set(n, vector);
        }
        vector.add(byArray);
    }

    private void checkOutParamExists(int n) throws SQLException {
        if (this.outParamBytes[n] == null) {
            throw TbError.newSQLException(-90609);
        }
    }

    public synchronized boolean execute() throws SQLException {
        if (this.haveNamedParameter && this.haveOrdinalParameter) {
            throw TbError.newSQLException(-90655);
        }
        if (this.namedParamCnt > 0) {
            this.rewriteQuestionToNamedParam();
        }
        return super.execute();
    }

    public synchronized int executeUpdate() throws SQLException {
        if (this.haveNamedParameter && this.haveOrdinalParameter) {
            throw TbError.newSQLException(-90655);
        }
        if (this.namedParamCnt > 0) {
            this.rewriteQuestionToNamedParam();
        }
        return super.executeUpdate();
    }

    public Array getArray(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getArrayInternal(n);
    }

    public Array getArray(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getArrayInternal(n);
    }

    private Array getArrayInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        byte[] byArray = this.outParamBytes[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        String string = this.typeConverter.toString(byArray, 0, 32, 3, false);
        int n2 = TbCommon.bytes2Int(byArray, 32, 4);
        int n3 = TbCommon.bytes2Int(byArray, 36, 4);
        TbArrayDescriptor tbArrayDescriptor = TbArrayDescriptor.createDescriptor(29, string, n2, n3, this.conn);
        bindItem.setTypeDescriptor(tbArrayDescriptor);
        return this.typeConverter.toArray(byArray, 40, bindItem.getLength(), DataType.getDataType(bindItem.getSQLType()), !this.getRealRsetType().isScrollable(), tbArrayDescriptor, this.conn.getTypeMap());
    }

    public Struct getStruct(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getStructInternal(n);
    }

    private Struct getStructInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return (Struct)this.typeConverter.toStruct(this.outParamBytes[n - 1], 0, bindItem.getLength(), bindItem.getSQLType(), !this.getRealRsetType().isScrollable(), null, null, this.conn.getTypeMap());
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBigDecimalInternal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getBigDecimalInternal(n);
    }

    private BigDecimal getBigDecimalInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toBigDecimal(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBlobInternal(n);
    }

    public Blob getBlob(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getBlobInternal(n);
    }

    private Blob getBlobInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toBlob(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1], false);
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBooleanInternal(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getBooleanInternal(n);
    }

    private boolean getBooleanInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return false;
        }
        return this.typeConverter.toBoolean(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public byte getByte(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getByteInternal(n);
    }

    public byte getByte(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getByteInternal(n);
    }

    private byte getByteInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return 0;
        }
        return this.typeConverter.toByte(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBytesInternal(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getBytesInternal(n);
    }

    private byte[] getBytesInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toBytes((Object)this.outParamBytes[n - 1], 0, bindItem.getLength(), (int)this.outParamTypes[n - 1], false);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getCharacterStreamInternal(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getCharacterStreamInternal(n);
    }

    private Reader getCharacterStreamInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public Clob getClob(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getClobInternal(n);
    }

    public Clob getClob(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getClobInternal(n);
    }

    private Clob getClobInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toClob(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1], false);
    }

    public Date getDate(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getDateInternal(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        Date date = this.getDateInternal(n);
        if (calendar != null) {
            calendar.setTime(date);
            date = (Date)calendar.getTime();
        }
        return date;
    }

    public Date getDate(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getDateInternal(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getDate(n, calendar);
    }

    private Date getDateInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toDate(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public TbDate getTbDate(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTbDateInternal(n);
    }

    public TbDate getTbDate(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getTbDateInternal(n);
    }

    private TbDate getTbDateInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toTbDate(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public double getDouble(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getDoubleInternal(n);
    }

    public double getDouble(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getDoubleInternal(n);
    }

    private double getDoubleInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return 0.0;
        }
        return this.typeConverter.toDouble(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public float getFloat(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getFloatInternal(n);
    }

    public float getFloat(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getFloatInternal(n);
    }

    private float getFloatInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return 0.0f;
        }
        return this.typeConverter.toFloat(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public int getInt(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getIntInternal(n);
    }

    public int getInt(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getIntInternal(n);
    }

    private int getIntInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return 0;
        }
        return this.typeConverter.toInt(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public long getLong(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getLongInternal(n);
    }

    public long getLong(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getLongInternal(n);
    }

    private long getLongInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return 0L;
        }
        return this.typeConverter.toLong(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getCharacterStreamInternal(n);
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getCharacterStreamInternal(n);
    }

    public String getNString(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getStringInternal(n);
    }

    public String getNString(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getStringInternal(n);
    }

    public Object getObject(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getObjectInternal(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        TbStruct tbStruct = (TbStruct)this.getObjectInternal(n);
        if (map == null) {
            return tbStruct;
        }
        String string = tbStruct.getSQLTypeName();
        Class clazz = (Class)map.get(string);
        return tbStruct.toClass(clazz, map);
    }

    public Object getObject(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getObjectInternal(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getObject(n, map);
    }

    private Object getObjectInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        byte[] byArray = this.outParamBytes[n - 1];
        if (bindItem.getParamMode() == 1) {
            throw TbError.newSQLException(-590772);
        }
        if (this.outParamTypes[n - 1] == 16) {
            if (this.outPrefetchedRs[n - 1] == null) {
                return this.typeConverter.toResultSet(this, this.outParamBytes[n - 1], bindItem);
            }
            return this.outPrefetchedRs[n - 1];
        }
        if (this.outParamTypes[n - 1] == 32 || this.outParamTypes[n - 1] == 28) {
            if (this.setLastColumnWasNull(bindItem)) {
                return null;
            }
            String string = this.typeConverter.toString(byArray, 0, 32, 3, false);
            int n2 = TbCommon.bytes2Int(byArray, 32, 4);
            int n3 = TbCommon.bytes2Int(byArray, 36, 4);
            TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(32, string, n2, n3, this.conn);
            bindItem.setTypeDescriptor(tbStructDescriptor);
            return this.typeConverter.toStruct(byArray, 40, bindItem.getLength(), DataType.getDataType(bindItem.getSQLType()), !this.getRealRsetType().isScrollable(), tbStructDescriptor, null, null);
        }
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toObject(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1], bindItem.getSQLType(), true);
    }

    public BindItem getOutItems(int n) {
        return this.outItems[n];
    }

    public Vector getPivotData(int n) throws SQLException {
        if (this.outParamTypes[n - 1] == 16) {
            if (this.pivotDataArr == null || this.pivotDataArr.get(n - 1) == null) {
                int n2 = TbCommon.bytes2Int(this.outParamBytes[n - 1], 0, this.outItems[n - 1].getLength());
                this.conn.getTbComm().executePivot(this, n - 1, n2);
            }
            if (this.pivotDataArr != null) {
                return (Vector)this.pivotDataArr.get(n - 1);
            }
        }
        return null;
    }

    public TbPivotInfo[] getPivotInfo(int n) throws SQLException {
        if (this.outParamTypes[n - 1] == 16) {
            if (this.pivotInfoArr == null || this.pivotInfoArr[n - 1] == null) {
                int n2 = TbCommon.bytes2Int(this.outParamBytes[n - 1], 0, this.outItems[n - 1].getLength());
                this.conn.getTbComm().executePivot(this, n - 1, n2);
            }
            if (this.pivotInfoArr != null) {
                return this.pivotInfoArr[n - 1];
            }
        }
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public Ref getRef(String string) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public short getShort(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getShortInternal(n);
    }

    public short getShort(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getShortInternal(n);
    }

    private short getShortInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return 0;
        }
        return this.typeConverter.toShort(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public String getString(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getStringInternal(n);
    }

    public String getString(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getStringInternal(n);
    }

    private String getStringInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toString(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1], true);
    }

    public Time getTime(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTimeInternal(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTimeInternal(n);
        if (calendar != null) {
            calendar.setTime(time);
            time = (Time)calendar.getTime();
        }
        return time;
    }

    public Time getTime(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getTimeInternal(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getTime(n, calendar);
    }

    private Time getTimeInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toTime(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTimestampInternal(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        Timestamp timestamp = this.getTimestampInternal(n);
        if (calendar != null) {
            calendar.setTime(timestamp);
            timestamp = (Timestamp)calendar.getTime();
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getTimestampInternal(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getTimestamp(n, calendar);
    }

    private Timestamp getTimestampInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toTimestamp(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public TbTimestamp getTbTimestamp(int n) throws SQLException {
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTbTimestampInternal(n);
    }

    public TbTimestamp getTbTimestamp(String string) throws SQLException {
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int n = this.addNamedParam(string);
        return this.getTbTimestampInternal(n);
    }

    private TbTimestamp getTbTimestampInternal(int n) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(n - 1);
        BindItem bindItem = this.outItems[n - 1];
        if (this.setLastColumnWasNull(bindItem)) {
            return null;
        }
        return this.typeConverter.toTbTimestamp(this.outParamBytes[n - 1], 0, bindItem.getLength(), this.outParamTypes[n - 1]);
    }

    public URL getURL(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public URL getURL(String string) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameterInternal(n, n2, n3, null);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameterInternal(n, n2, 0, string);
    }

    public synchronized void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(string, n, 0);
    }

    public synchronized void registerOutParameter(String string, int n, int n2) throws SQLException {
        int n3 = this.addNamedParam(string);
        this.registerOutParameterInternal(n3, n, n2, null);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        int n2 = this.addNamedParam(string);
        this.registerOutParameterInternal(n2, n, 0, string2);
    }

    private void registerOutParameterInternal(int n, int n2, int n3, String string) throws SQLException {
        switch (n2) {
            case -2003: 
            case 2003: {
                this.bindData.setOUTParam(n - 1, n2, string, this.conn);
                if (this.binder[this.currentRowIndex][n - 1] == null) {
                    this.binder[this.currentRowIndex][n - 1] = this.staticArrayOutBinder;
                }
                int n4 = this.bindData.getBindItem(n - 1).getTypeDescriptor().getDataType();
                this.setParamTypes(n - 1, (byte)n4);
                break;
            }
            case 2002: {
                this.bindData.setOUTParam(n - 1, n2, string, this.conn);
                if (this.binder[this.currentRowIndex][n - 1] == null) {
                    this.binder[this.currentRowIndex][n - 1] = this.staticStructOutBinder;
                }
                int n5 = this.bindData.getBindItem(n - 1).getTypeDescriptor().getDataType();
                this.setParamTypes(n - 1, (byte)n5);
                break;
            }
            default: {
                this.bindData.setOUTParam(n - 1, n2, string);
                if (this.binder[this.currentRowIndex][n - 1] == null) {
                    this.binder[this.currentRowIndex][n - 1] = this.staticNullBinder;
                }
                int n6 = DataType.getDataType(n2);
                this.setParamTypes(n - 1, (byte)n6);
            }
        }
    }

    protected void reset() {
        super.reset();
        this.namedParamArr = null;
        this.outParamBytes = null;
        this.outParamTypes = null;
        this.outPrefetchedRs = null;
        this.outItems = null;
    }

    public synchronized void resetForCache() {
        super.resetForCache();
        this.namedParamArr = null;
        this.outParamBytes = null;
        this.outParamTypes = null;
        this.outPrefetchedRs = null;
        this.outItems = null;
    }

    private void rewriteQuestionToNamedParam() throws SQLException {
        int n = 0;
        char[] cArray = this.originalSql.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (super.getParameterCnt() != this.namedParamCnt) {
            throw TbError.newSQLException(-90627);
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '?') {
                stringBuffer.append(this.namedParamArr[n++]);
                stringBuffer.append("=>?");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (n != this.namedParamCnt) {
            throw TbError.newSQLException(-90627);
        }
        this.originalSql = new String(stringBuffer);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(n, inputStream, Integer.MAX_VALUE);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(n, inputStream, n2);
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(n, inputStream, (int)l);
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBinaryStreamInternal(n, inputStream, Integer.MAX_VALUE);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setBinaryStreamInternal(n2, inputStream, n);
    }

    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        int n = this.addNamedParam(string);
        super.setBinaryStreamInternal(n, inputStream, (int)l);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBigDecimalInternal(n, bigDecimal);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBigDecimalInternal(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(n, inputStream, Integer.MAX_VALUE);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(n, inputStream, (int)l);
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBinaryStreamInternal(n, inputStream, Integer.MAX_VALUE);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setBinaryStreamInternal(n2, inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        int n = this.addNamedParam(string);
        super.setBinaryStreamInternal(n, inputStream, (int)l);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBlobInternal(n, blob);
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBlobInternal(n, inputStream, Integer.MAX_VALUE);
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBlobInternal(n, inputStream, l);
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBlobInternal(n, blob);
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBlobInternal(n, inputStream, Integer.MAX_VALUE);
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBlobInternal(n, inputStream, l);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBooleanInternal(n, bl);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBooleanInternal(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setByteInternal(n, by);
    }

    public void setByte(String string, byte by) throws SQLException {
        int n = this.addNamedParam(string);
        super.setByteInternal(n, by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBytesInternal(n, 4, byArray);
    }

    public void setBytes(int n, int n2, byte[] byArray) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setBytesInternal(n, n2, byArray);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        int n = this.addNamedParam(string);
        super.setBytesInternal(n, 4, byArray);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setCharacterStreamInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setCharacterStreamInternal(n, reader, n2);
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.haveOrdinalParameter = true;
        super.setCharacterStreamInternal(n, reader, (int)l);
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.addNamedParam(string);
        super.setCharacterStreamInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setCharacterStreamInternal(n2, reader, n);
    }

    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        int n = this.addNamedParam(string);
        super.setCharacterStreamInternal(n, reader, (int)l);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setClobInternal(n, 13, clob);
    }

    public void setClob(int n, Reader reader) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setClobInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setClobInternal(n, reader, l);
    }

    public void setClob(String string, Clob clob) throws SQLException {
        int n = this.addNamedParam(string);
        super.setClobInternal(n, 13, clob);
    }

    public void setClob(String string, Reader reader) throws SQLException {
        int n = this.addNamedParam(string);
        super.setClobInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        int n = this.addNamedParam(string);
        super.setClobInternal(n, reader, l);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setDateInternal(n, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setDateInternal(n, date);
    }

    public void setDate(String string, Date date) throws SQLException {
        int n = this.addNamedParam(string);
        super.setDateInternal(n, date);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        int n = this.addNamedParam(string);
        super.setDateInternal(n, date);
    }

    public void setTbDate(int n, TbDate tbDate) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setTbDateInternal(n, tbDate);
    }

    public void setTbDate(String string, TbDate tbDate) throws SQLException {
        int n = this.addNamedParam(string);
        super.setTbDateInternal(n, tbDate);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setDoubleInternal(n, d);
    }

    public void setDouble(String string, double d) throws SQLException {
        int n = this.addNamedParam(string);
        super.setDoubleInternal(n, d);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setFloatInternal(n, f);
    }

    public void setFloat(String string, float f) throws SQLException {
        int n = this.addNamedParam(string);
        super.setFloatInternal(n, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setIntInternal(n, n2);
    }

    public void setInt(String string, int n) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setIntInternal(n2, n);
    }

    private synchronized boolean setLastColumnWasNull(BindItem bindItem) {
        this.lastColumnWasNull = bindItem.getLength() == 0;
        return this.lastColumnWasNull;
    }

    public void setLong(int n, long l) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setLongInternal(n, l);
    }

    public void setLong(String string, long l) throws SQLException {
        int n = this.addNamedParam(string);
        super.setLongInternal(n, l);
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setNCharacterStreamInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.haveOrdinalParameter = true;
        super.setNCharacterStreamInternal(n, reader, (int)l);
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.addNamedParam(string);
        super.setNCharacterStreamInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        int n = this.addNamedParam(string);
        super.setNCharacterStreamInternal(n, reader, (int)l);
    }

    public void setNClob(int n, Clob clob) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setClobInternal(n, 20, clob);
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setNClobInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.haveOrdinalParameter = true;
        super.setNClobInternal(n, reader, (int)l);
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        int n = this.addNamedParam(string);
        super.setNClobInternal(n, reader, Integer.MAX_VALUE);
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        int n = this.addNamedParam(string);
        super.setNClobInternal(n, reader, (int)l);
    }

    public void setNString(int n, String string) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setNStringInternal(n, string);
    }

    public void setNString(String string, String string2) throws SQLException {
        int n = this.addNamedParam(string);
        super.setNStringInternal(n, string2);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setNullInternal(n, DataType.getDataType(n2));
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setNullInternal(n, DataType.getDataType(n2));
    }

    public void setNull(String string, int n) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setNullInternal(n2, n);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setNullInternal(n2, n);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, DataType.getSqlType(object), 0);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setObjectInternal(n, object, n2, n3);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(string, object, DataType.getSqlType(object), 0);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(string, object, n, 0);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        int n3 = this.addNamedParam(string);
        super.setObjectInternal(n3, object, n, n2);
    }

    public void setOutParam(int n, int n2, byte[] byArray, TbResultSet tbResultSet) throws SQLException {
        DataType.checkValidDataType(n2);
        this.outParamTypes[n] = (byte)n2;
        this.outParamBytes[n] = byArray;
        this.outPrefetchedRs[n] = tbResultSet;
    }

    public void setPivotInfo(int n, TbPivotInfo[] tbPivotInfoArray) {
        if (this.pivotInfoArr == null) {
            this.pivotInfoArr = new TbPivotInfo[this.bindParamCnt][];
        }
        this.pivotInfoArr[n] = tbPivotInfoArray;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setShort(int n, short s) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setShortInternal(n, s);
    }

    public void setShort(String string, short s) throws SQLException {
        int n = this.addNamedParam(string);
        super.setShortInternal(n, s);
    }

    public void setString(int n, String string) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setStringInternal(n, string);
    }

    public void setString(String string, String string2) throws SQLException {
        int n = this.addNamedParam(string);
        super.setStringInternal(n, string2);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setTimeInternal(n, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setTimeInternal(n, time);
    }

    public void setTime(String string, Time time) throws SQLException {
        int n = this.addNamedParam(string);
        super.setTimeInternal(n, time);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        int n = this.addNamedParam(string);
        super.setTimeInternal(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setTimestampInternal(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setTimestampInternal(n, timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n = this.addNamedParam(string);
        super.setTimestampInternal(n, timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n = this.addNamedParam(string);
        super.setTimestampInternal(n, timestamp);
    }

    public void setTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setTbTimestampInternal(n, tbTimestamp);
    }

    public void setTbTimestamp(String string, TbTimestamp tbTimestamp) throws SQLException {
        int n = this.addNamedParam(string);
        super.setTbTimestampInternal(n, tbTimestamp);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.haveOrdinalParameter = true;
        super.setUnicodeStreamInternal(n, inputStream, n2);
    }

    public void setUnicodeStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.addNamedParam(string);
        super.setUnicodeStreamInternal(n2, inputStream, n);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }
}

