/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.sql.SQLException;

public class TbRSFwOnly
extends TbResultSetBase {
    private Row row;
    private int chunkOffset;
    protected int lastFetchedCnt;

    protected TbRSFwOnly(TbStatement tbStatement, int n, int n2, int n3, byte[] byArray) throws SQLException {
        super(tbStatement, n, n2, n3, byArray);
        this.currentRowIndex = -1;
        tbStatement.conn.addFOActiveResultSet(this);
    }

    public void buildRowTable(int n, byte[] byArray) throws SQLException {
        this.chunkOffset = 1;
        if (this.rowsFetchedCnt + n < 0) {
            throw TbError.newSQLException(-90613);
        }
        this.lastFetchedCnt = this.rowsFetchedCnt;
        this.rowsFetchedCnt += n;
        this.currentFetchCount = n;
        if (this.row == null) {
            this.row = new Row(this.columnCount);
        }
        this.rowChunk = byArray;
    }

    private void checkRowIndex(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.stmt.getMaxRows() != 0 && n >= this.stmt.getMaxRows() || n >= this.rowsFetchedCnt && this.fetchComplete) {
            throw TbError.newSQLException(-90647);
        }
        if (n < this.lastFetchedCnt || this.stmt.getMaxRows() != 0 && n >= this.stmt.getMaxRows() || n >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
    }

    protected Row getCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        return this.row;
    }

    public synchronized boolean next() throws SQLException {
        if (!super.next()) {
            this.closeCursor();
            return false;
        }
        this.chunkOffset += this.row.buildRowData(this.rowChunk, this.chunkOffset, this.cols);
        return true;
    }

    protected void removeCurrentRow() throws SQLException {
    }

    protected void recover() throws SQLException {
        this.setFOECode(0);
        if (this.stmt == null) {
            throw TbError.newSQLException(-90702, "stmt=null");
        }
        if (!TbSQLTypeScanner.isQueryStmt(this.stmt.getSqlType())) {
            throw TbError.newSQLException(-90702, "sqlType=" + this.stmt.getSqlType());
        }
        if (this.stmt.getRealRsetType().isSensitive() || this.stmt.getRealRsetType().isUpdatable()) {
            throw TbError.newSQLException(-90702, "realRsetType=" + this.stmt.getRealRsetType());
        }
        if (this.stmt.isReturnAutoGeneratedKeys()) {
            throw TbError.newSQLException(-90702, "autoGenKeys=true");
        }
        if (this.stmt instanceof TbPreparedStatementImpl) {
            TbPreparedStatementImpl tbPreparedStatementImpl = (TbPreparedStatementImpl)this.stmt;
            if (tbPreparedStatementImpl.getBatchRowCount() > 0) {
                throw TbError.newSQLException(-90702, "BatchRowCnt=" + tbPreparedStatementImpl.getBatchRowCount());
            }
            BindData bindData = tbPreparedStatementImpl.getBindData();
            if (bindData.getDFRParameterCnt() > 0) {
                throw TbError.newSQLException(-90702, "DFRParamCnt=" + bindData.getDFRParameterCnt());
            }
            tbPreparedStatementImpl.setPPID(null);
            try {
                tbPreparedStatementImpl.conn.getTbComm().prepareExecute(tbPreparedStatementImpl, tbPreparedStatementImpl.getOriginalSql(), 0);
            }
            catch (Exception exception) {
                throw TbError.newSQLException(-90701, exception);
            }
        }
        try {
            this.stmt.conn.getTbComm().executeDirect(this.stmt, this.stmt.getOriginalSql());
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90701, exception);
        }
        if (this.stmt.currentRs == null) {
            throw TbError.newSQLException(-90702, "failoverRset=null");
        }
        if (!(this.stmt.currentRs instanceof TbRSFwOnly)) {
            throw TbError.newSQLException(-90702, "failoverRsetClass=" + this.stmt.currentRs.getClass().getName());
        }
        int n = 1;
        for (int i = 0; i < this.currentFetchCount; ++i) {
            n += this.row.buildRowData(this.rowChunk, n, this.cols);
        }
        long l = this.getCurrentChunkCRC(this.rowChunk, n, 0L);
        TbRSFwOnly tbRSFwOnly = (TbRSFwOnly)this.stmt.currentRs;
        while (tbRSFwOnly.currentRowIndex < this.lastFetchedCnt) {
            tbRSFwOnly.next();
        }
        long l2 = -1L;
        if (tbRSFwOnly.rowChunk.length > n) {
            l2 = this.getCurrentChunkCRC(tbRSFwOnly.rowChunk, n, l);
        }
        if (l2 != 0L) {
            throw TbError.newSQLException(-90702, "failoverRset invalid.");
        }
        while (tbRSFwOnly.currentRowIndex < this.currentRowIndex - 1) {
            tbRSFwOnly.next();
        }
        this.csrID = tbRSFwOnly.csrID;
        this.fetchComplete = tbRSFwOnly.fetchComplete;
        this.stmt.setResultSet(this);
        this.typeConverter = this.stmt.conn.getTypeConverter();
        tbRSFwOnly.reset();
    }

    protected void reset() {
        super.reset();
        if (this.row != null) {
            this.row.close();
            this.row = null;
        }
    }

    public boolean absolute(int n) throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public void afterLast() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public void beforeFirst() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean first() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean isLast() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean last() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean previous() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    public boolean relative(int n) throws SQLException {
        throw TbError.newSQLException(-90620);
    }
}

