/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.ws.server.SmartEndpointInterceptor;
import org.springframework.ws.soap.server.endpoint.interceptor.DelegatingSmartSoapEndpointInterceptor;
import org.springframework.ws.soap.server.endpoint.interceptor.PayloadRootSmartSoapEndpointInterceptor;
import org.springframework.ws.soap.server.endpoint.interceptor.SoapActionSmartEndpointInterceptor;
import org.w3c.dom.Element;

class InterceptorsBeanDefinitionParser
implements BeanDefinitionParser {
    InterceptorsBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compDefinition);
        List childElements = DomUtils.getChildElements((Element)element);
        for (Element childElement : childElements) {
            BeanReference interceptorRef;
            BeanDefinitionHolder interceptorDef;
            RootBeanDefinition smartInterceptorDef;
            RootBeanDefinition smartInterceptorDef2;
            if ("bean".equals(childElement.getLocalName())) {
                smartInterceptorDef2 = this.createSmartInterceptorDefinition(DelegatingSmartSoapEndpointInterceptor.class, childElement, parserContext);
                BeanDefinitionHolder interceptorDef2 = this.createInterceptorDefinition(parserContext, childElement);
                smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorDef2);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef2);
                continue;
            }
            if ("ref".equals(childElement.getLocalName())) {
                smartInterceptorDef2 = this.createSmartInterceptorDefinition(DelegatingSmartSoapEndpointInterceptor.class, childElement, parserContext);
                BeanReference interceptorRef2 = this.createInterceptorReference(parserContext, childElement);
                smartInterceptorDef2.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorRef2);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef2);
                continue;
            }
            if ("payloadRoot".equals(childElement.getLocalName())) {
                List payloadRootChildren = DomUtils.getChildElements((Element)childElement);
                for (Element payloadRootChild : payloadRootChildren) {
                    String localPart;
                    String namespaceUri;
                    if ("bean".equals(payloadRootChild.getLocalName())) {
                        smartInterceptorDef = this.createSmartInterceptorDefinition(PayloadRootSmartSoapEndpointInterceptor.class, childElement, parserContext);
                        interceptorDef = this.createInterceptorDefinition(parserContext, payloadRootChild);
                        namespaceUri = childElement.getAttribute("namespaceUri");
                        localPart = childElement.getAttribute("localPart");
                        smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorDef);
                        smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)namespaceUri);
                        smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)localPart);
                        this.registerSmartInterceptor(parserContext, smartInterceptorDef);
                        continue;
                    }
                    if (!"ref".equals(payloadRootChild.getLocalName())) continue;
                    smartInterceptorDef = this.createSmartInterceptorDefinition(PayloadRootSmartSoapEndpointInterceptor.class, childElement, parserContext);
                    interceptorRef = this.createInterceptorReference(parserContext, payloadRootChild);
                    namespaceUri = childElement.getAttribute("namespaceUri");
                    localPart = childElement.getAttribute("localPart");
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorRef);
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)namespaceUri);
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)localPart);
                    this.registerSmartInterceptor(parserContext, smartInterceptorDef);
                }
                continue;
            }
            if (!"soapAction".equals(childElement.getLocalName())) continue;
            List soapActionChildren = DomUtils.getChildElements((Element)childElement);
            for (Element soapActionChild : soapActionChildren) {
                String soapAction;
                if ("bean".equals(soapActionChild.getLocalName())) {
                    smartInterceptorDef = this.createSmartInterceptorDefinition(SoapActionSmartEndpointInterceptor.class, childElement, parserContext);
                    interceptorDef = this.createInterceptorDefinition(parserContext, soapActionChild);
                    soapAction = childElement.getAttribute("value");
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorDef);
                    smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)soapAction);
                    this.registerSmartInterceptor(parserContext, smartInterceptorDef);
                    continue;
                }
                if (!"ref".equals(soapActionChild.getLocalName())) continue;
                smartInterceptorDef = this.createSmartInterceptorDefinition(SoapActionSmartEndpointInterceptor.class, childElement, parserContext);
                interceptorRef = this.createInterceptorReference(parserContext, soapActionChild);
                soapAction = childElement.getAttribute("value");
                smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interceptorRef);
                smartInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)soapAction);
                this.registerSmartInterceptor(parserContext, smartInterceptorDef);
            }
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void registerSmartInterceptor(ParserContext parserContext, RootBeanDefinition smartInterceptorDef) {
        String mappedInterceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)smartInterceptorDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)smartInterceptorDef, mappedInterceptorName));
    }

    private BeanDefinitionHolder createInterceptorDefinition(ParserContext parserContext, Element element) {
        BeanDefinitionHolder interceptorDef = parserContext.getDelegate().parseBeanDefinitionElement(element);
        interceptorDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(element, interceptorDef);
        return interceptorDef;
    }

    private BeanReference createInterceptorReference(ParserContext parserContext, Element element) {
        String refName = element.getAttribute("bean");
        if (!StringUtils.hasLength((String)refName) && !StringUtils.hasLength((String)(refName = element.getAttribute("local")))) {
            this.error(parserContext, "Either 'bean' or 'local' is required for <ref> element", element);
            return null;
        }
        if (!StringUtils.hasText((String)refName)) {
            this.error(parserContext, "<ref> element contains empty target attribute", element);
            return null;
        }
        RuntimeBeanReference ref = new RuntimeBeanReference(refName);
        ref.setSource(parserContext.extractSource((Object)element));
        return ref;
    }

    private RootBeanDefinition createSmartInterceptorDefinition(Class<? extends SmartEndpointInterceptor> interceptorClass, Element element, ParserContext parserContext) {
        RootBeanDefinition smartInterceptorDef = new RootBeanDefinition(interceptorClass);
        smartInterceptorDef.setSource(parserContext.extractSource((Object)element));
        smartInterceptorDef.setRole(2);
        return smartInterceptorDef;
    }

    private void error(ParserContext parserContext, String message, Object source) {
        parserContext.getDelegate().getReaderContext().error(message, source);
    }
}

