/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.service;

import com.its.app.config.AppUtils;
import com.its.app.mapper.UnitSystMapper;
import com.its.app.process.AbstractDbmsJobProcess;
import com.its.app.process.DbmsJobData;
import com.its.app.vo.voUnitSyst;
import com.its.app.vo.voUnitSystStts;
import com.its.utils.SysUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class UnitSystService {
    private static final Logger log = LoggerFactory.getLogger(UnitSystService.class);
    @Value(value="${process.id:ITS01}")
    private String processId;
    private UnitSystMapper unitSystMapper;
    private voUnitSyst unitSyst = new voUnitSyst();
    private voUnitSystStts unitSystStts = new voUnitSystStts();
    private ConcurrentHashMap<String, voUnitSyst> untiSystMap = new ConcurrentHashMap();
    private int sttsMin;
    public static String _srcIpAddr;

    @PostConstruct
    private void init() {
        log.info("[LOADING...] UnitSystService.init: start.");
        this.unitSystMapper = (UnitSystMapper)AppUtils.getBean(UnitSystMapper.class);
        InetAddress local = null;
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String localIp = local.getHostAddress();
        long ipAddr = SysUtils.ipToLong(localIp);
        _srcIpAddr = String.format("%03d.%03d.%03d.%03d-", ipAddr >> 24 & 0xFFL, ipAddr >> 16 & 0xFFL, ipAddr >> 8 & 0xFFL, ipAddr >> 0 & 0xFFL);
        log.info("[LOADING...] UnitSystService.init. _srcIpAddr: {}", (Object)_srcIpAddr);
        log.info("[LOADING...] UnitSystService.init. processId: {}", (Object)this.processId);
        log.info("[LOADING...] UnitSystService.init: ..end.");
    }

    @PreDestroy
    public void destroyService() {
        log.error("UnitSystService.destroy. system terminated.......");
        this.updateUnitSyst(false);
    }

    public void loadMaster() {
        try {
            for (Map.Entry<String, voUnitSyst> e : this.untiSystMap.entrySet()) {
                e.getValue().setDEL_YN("Y");
            }
            List<voUnitSyst> systList = this.unitSystMapper.selectAll();
            log.info("[LOADING...] UnitSystService.selectAll(), {} EA", (Object)systList.size());
            for (voUnitSyst unit : systList) {
                if (unit.getSYST_ID().equals(this.processId)) {
                    this.unitSystStts.setSYST_ID(this.processId);
                    String localIp = unit.getSYST_IP_1().trim();
                    long ipAddr = SysUtils.ipToLong(localIp);
                    _srcIpAddr = String.format("%03d.%03d.%03d.%03d-", ipAddr >> 24 & 0xFFL, ipAddr >> 16 & 0xFFL, ipAddr >> 8 & 0xFFL, ipAddr >> 0 & 0xFFL);
                    log.info("[LOADING...] UnitSystService.loadMaster: _srcIpAddr: {}", (Object)_srcIpAddr);
                }
                if (!unit.getSYST_TYPE().contentEquals("UOT")) continue;
                unit.setSYST_IP_1(unit.getSYST_IP_1().trim());
                this.untiSystMap.put(unit.getSYST_ID(), unit);
            }
        }
        catch (Exception e) {
            log.error("[LOADING...] UnitSystService.selectAll: Exception: {}", (Object)e.toString());
        }
    }

    public void updateUnitSyst(boolean isRun) {
        String keyData = "unit";
        MDC.put((String)"id", (String)keyData);
        boolean insHs = false;
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        if (min % 5 == 0) {
            insHs = true;
            this.sttsMin = min;
        }
        if (this.unitSystStts == null) {
            this.unitSystStts = new voUnitSystStts();
        }
        String SYST_STTS_CD = isRun ? "SPS1" : "SPC3";
        this.unitSystStts.setSYST_ID(this.processId);
        this.unitSystStts.setUPDT_DT(SysUtils.getSysTime());
        this.unitSystStts.setSYST_STTS_CD(SYST_STTS_CD);
        if (!isRun) {
            int res = this.unitSystMapper.updateUnitSystStts(this.unitSystStts);
            if (insHs) {
                res = this.unitSystMapper.insertUnitSystSttsHs(this.unitSystStts);
            }
        } else {
            AbstractDbmsJobProcess.addQ(new DbmsJobData(0, insHs, this.unitSystStts));
            if (insHs) {
                this.loadMaster();
            }
        }
        MDC.remove((String)keyData);
        MDC.clear();
    }

    public String getProcessId() {
        return this.processId;
    }

    public UnitSystMapper getUnitSystMapper() {
        return this.unitSystMapper;
    }

    public voUnitSyst getUnitSyst() {
        return this.unitSyst;
    }

    public voUnitSystStts getUnitSystStts() {
        return this.unitSystStts;
    }

    public ConcurrentHashMap<String, voUnitSyst> getUntiSystMap() {
        return this.untiSystMap;
    }

    public int getSttsMin() {
        return this.sttsMin;
    }
}

