/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.ASCIIByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class ASCIIDecoder
implements CharsetDecoder {
    private ASCIIByteToCharConverter conv = new ASCIIByteToCharConverter();

    public int bytesToChars(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws SQLException {
        return this.conv.convert(byArray, n, n + n2, cArray, n3, n3 + n4);
    }

    public String bytesToString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            return new String(byArray, n, n2, "EUC-KR");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }

    public String bytesToString(byte[] byArray) throws SQLException {
        return this.bytesToString(byArray, 0, byArray.length);
    }

    public int fixedBytesToChars(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        for (int i = n; i < n + n2; i += 2) {
            if (byArray[i] == 0) {
                if (byArray[i + 1] < 0) {
                    cArray[n5++] = (char)(byArray[i + 1] + 256);
                    continue;
                }
                cArray[n5++] = (char)byArray[i + 1];
                continue;
            }
            n5 += this.conv.convert(byArray, i, i + 2, cArray, n5, n5 + 2);
        }
        return n5 - n3;
    }

    public String fixedBytesToString(byte[] byArray, int n, int n2) throws SQLException {
        return null;
    }

    public String fixedBytesToString(byte[] byArray) throws SQLException {
        return null;
    }
}

