/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbCommon {
    private static byte[] POSITIVE_INFINITY_FLOAT_BYTES = new byte[]{-1, -128, 0, 0};
    private static byte[] NEGATIVE_INFINITY_FLOAT_BYTES = new byte[]{0, 127, -1, -1};
    private static byte[] MAX_VALUE_FLOAT_BYTES = new byte[]{127, 127, -1, -1};
    private static byte[] MIN_VALUE_FLOAT_BYTES = new byte[]{0, 0, 0, 1};
    private static byte[] NAN_FLOAT_BYTES = new byte[]{-1, -64, 0, 0};
    private static byte[] NEGATIVE_ZERO_FLOAT_BYTES = new byte[]{-128, 0, 0, 0};
    private static byte[] POSITIVE_INFINITY_DOUBLE_BYTES = new byte[]{-1, -16, 0, 0, 0, 0, 0, 0};
    private static byte[] NEGATIVE_INFINITY_DOUBLE_BYTES = new byte[]{0, 15, -1, -1, -1, -1, -1, -1};
    private static byte[] MAX_VALUE_DOUBLE_BYTES = new byte[]{127, -17, -1, -1, -1, -1, -1, -1};
    private static byte[] MIN_VALUE_DOUBLE_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
    private static byte[] NAN_DOUBLE_BYTES = new byte[]{-1, -8, 0, 0, 0, 0, 0, 0};
    private static byte[] NEGATIVE_ZERO_DOUBLE_BYTES = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};

    private static boolean equalsBytes(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n3 = byArray.length;
        if (n2 != n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isPositiveInfinityFloatBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(POSITIVE_INFINITY_FLOAT_BYTES, byArray, n, n2);
    }

    public static boolean isNegativeInfinityFloatBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(NEGATIVE_INFINITY_FLOAT_BYTES, byArray, n, n2);
    }

    public static boolean isMaxValueFloatBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(MAX_VALUE_FLOAT_BYTES, byArray, n, n2);
    }

    public static boolean isMinValueFloatBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(MIN_VALUE_FLOAT_BYTES, byArray, n, n2);
    }

    public static boolean isNanFloatBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(NAN_FLOAT_BYTES, byArray, n, n2);
    }

    public static boolean isNegativeZeroFloatBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(NEGATIVE_ZERO_FLOAT_BYTES, byArray, n, n2);
    }

    public static boolean isPositiveInfinityDoubleBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(POSITIVE_INFINITY_DOUBLE_BYTES, byArray, n, n2);
    }

    public static boolean isNegativeInfinityDoubleBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(NEGATIVE_INFINITY_DOUBLE_BYTES, byArray, n, n2);
    }

    public static boolean isMaxValueDoubleBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(MAX_VALUE_DOUBLE_BYTES, byArray, n, n2);
    }

    public static boolean isMinValueDoubleBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(MIN_VALUE_DOUBLE_BYTES, byArray, n, n2);
    }

    public static boolean isNanDoubleBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(NAN_DOUBLE_BYTES, byArray, n, n2);
    }

    public static boolean isNegativeZeroDoubleBytes(byte[] byArray, int n, int n2) {
        return TbCommon.equalsBytes(NEGATIVE_ZERO_DOUBLE_BYTES, byArray, n, n2);
    }

    public static int bytes2Int(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= (0xFF & byArray[n + i]) << 8 * (n2 - 1 - i);
        }
        return n3;
    }

    public static int bytes2IntR(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= (0xFF & byArray[n + i]) << 8 * i;
        }
        return n3;
    }

    public static long bytes2Long(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l |= (0xFFL & (long)byArray[n + i]) << 8 * (n2 - 1 - i);
        }
        return l;
    }

    public static long bytes2LongR(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l |= (0xFFL & (long)byArray[n + i]) << 8 * i;
        }
        return l;
    }

    public static String bytes2String(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append((char)TbCommon.raw2Hex((byte)((byArray[n + i] & 0xF0) >> 4)));
            stringBuffer.append((char)TbCommon.raw2Hex((byte)(byArray[n + i] & 0xF)));
        }
        return stringBuffer.toString();
    }

    public static boolean getBitmapAt(int n, int n2) {
        int n3 = 1;
        return (n2 & (n3 <<= n)) != 0;
    }

    public static String getEmptyString(String string, String string2) {
        return string != null ? string : string2;
    }

    public static int getPadLength(int n) {
        int n2 = (4 - n % 4) % 4;
        return n2 == 0 ? 4 : n2;
    }

    public static int int2Bytes(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + n3 - 1 - i] = (byte)(0xFF & n >> 8 * i);
        }
        return n3;
    }

    public static int int2BytesR(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = (byte)(0xFF & n >> 8 * i);
        }
        return n3;
    }

    public static int long2Bytes(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + n2 - 1 - i] = (byte)(0xFFL & l >> 8 * i);
        }
        return n2;
    }

    public static int long2BytesR(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)(0xFFL & l >> 8 * i);
        }
        return n2;
    }

    private static byte raw2Hex(byte by) {
        return (byte)((by = (byte)(by & 0xF)) >= 10 ? by - 10 + 65 : by + 48);
    }

    public static void writePadding(byte[] byArray, int n, int n2) {
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                byArray[n + i] = 0;
            }
        }
    }

    private TbCommon() {
    }
}

