/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.process;

import com.its.app.config.AppUtils;
import com.its.app.mapper.UnitSystMapper;
import com.its.app.process.DbmsJobData;
import com.its.app.process.DbmsJobTask;
import com.its.app.thread.ItsThreadPoolInitializer;
import com.its.app.vo.voUnitSystStts;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDbmsJobProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbmsJobProcess.class);
    public static LinkedBlockingQueue<DbmsJobData> DBMS_DATA_QUEUE = new LinkedBlockingQueue(1000);
    private UnitSystMapper unitSystMapper;
    private ThreadPoolExecutor taskExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    int MAX_CORE = Runtime.getRuntime().availableProcessors();

    @PostConstruct
    void init() {
        this.unitSystMapper = (UnitSystMapper)AppUtils.getBean(UnitSystMapper.class);
        this.postConstruct();
    }

    protected abstract void postConstruct();

    public void run() {
        log.info("AbstractDbmsJobProcess.run: Start.");
        if (this.MAX_CORE < 8) {
            this.MAX_CORE = 8;
        }
        ItsThreadPoolInitializer poolInitializer = (ItsThreadPoolInitializer)((Object)AppUtils.getBean(ItsThreadPoolInitializer.class));
        int executePool = Math.max(this.MAX_CORE, poolInitializer.getThreadPoolWork());
        for (int ii = 0; ii < executePool; ++ii) {
            log.info("AbstractDbmsJobProcess.Task: {}", (Object)ii);
            this.taskExecutor.execute(() -> {
                while (true) {
                    try {
                        while (true) {
                            DbmsJobData dbmsJobData;
                            if ((dbmsJobData = DBMS_DATA_QUEUE.take()) != null) {
                                DbmsJobTask handler = (DbmsJobTask)AppUtils.getBean(DbmsJobTask.class);
                                handler.run(this, dbmsJobData);
                                continue;
                            }
                            log.error("AbstractDbmsJobProcess.Task: Received data null");
                        }
                    }
                    catch (Exception e) {
                        log.error("AbstractDbmsJobProcess.Task: Exception: {}", (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    break;
                }
            });
        }
        log.info("AbstractDbmsJobProcess.run: ..End.");
    }

    public boolean add(DbmsJobData dbmsJobData) {
        boolean offer = false;
        try {
            offer = DBMS_DATA_QUEUE.offer(dbmsJobData);
            if (!offer) {
                log.error("DbmsJobProcess.add: Queue Full Error, Size: {} EA", (Object)DBMS_DATA_QUEUE.size());
            }
        }
        catch (Exception e) {
            log.error("DbmsJobProcess.add: Exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return offer;
    }

    public static boolean addQ(DbmsJobData dbmsJobData) {
        try {
            if (!DBMS_DATA_QUEUE.offer(dbmsJobData)) {
                log.error("AbstractDbmsJobProcess.add: Queue Full Error, Size: {} EA", (Object)DBMS_DATA_QUEUE.size());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error("AbstractDbmsJobProcess.add: Exception: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public void runJob(DbmsJobData dbmsJobData) {
        if (dbmsJobData.getType() == 0) {
            voUnitSystStts stts = (voUnitSystStts)dbmsJobData.getData();
            this.unitSystMapper.updateUnitSystStts(stts);
            if (dbmsJobData.isHistory()) {
                this.unitSystMapper.insertUnitSystSttsHs(stts);
            }
        } else {
            this.process(dbmsJobData);
        }
    }

    public abstract void process(DbmsJobData var1);
}

