/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.service.dao;

import com.its.utils.Elapsed;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchDaoService {
    private static final Logger log = LoggerFactory.getLogger(BatchDaoService.class);
    protected final int MAX_BATCH_SIZE = 1000;
    protected final SqlSessionFactory sqlSessionFactory;
    protected String serviceName;
    protected String mapperName;
    protected String mapper;
    protected int count;

    public BatchDaoService(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public int getCount() {
        return this.count;
    }

    public String getMapper() {
        return this.mapper;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBatch(String mapper, List<HashMap<String, Object>> lists) {
        log.debug("{}.insertBatch: {}: START.", (Object)this.serviceName, (Object)mapper);
        this.mapper = mapper;
        String mapperName = this.mapperName + this.mapper;
        Elapsed elapsed = new Elapsed();
        int total = lists.size();
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (Map map : lists) {
                sqlSession.insert(mapperName, (Object)map);
                if (++jobCnt % this.MAX_BATCH_SIZE != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        catch (Exception e) {
            log.error("{}.insertBatch: {}{}: ERROR. Exception: {}.", new Object[]{this.serviceName, mapperName, mapper, e.toString()});
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        log.debug("{}.insertBatch: {}: ..END. {} EA. {} ms.", new Object[]{this.serviceName, mapper, total, elapsed.milliSeconds()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBatch(String mapper, List<HashMap<String, Object>> lists) {
        log.debug("{}.updateBatch: {}: START.", (Object)this.serviceName, (Object)mapper);
        this.mapper = mapper;
        String mapperName = this.mapperName + this.mapper;
        Elapsed elapsed = new Elapsed();
        int total = lists.size();
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (Map map : lists) {
                sqlSession.update(mapperName, (Object)map);
                if (++jobCnt % this.MAX_BATCH_SIZE != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        catch (Exception e) {
            log.error("{}.updateBatch: {}{}: ERROR. Exception: {}.", new Object[]{this.serviceName, mapperName, mapper, e.toString()});
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        log.debug("{}.updateBatch: {}: ..END. {} EA. {} ms.", new Object[]{this.serviceName, mapper, total, elapsed.milliSeconds()});
    }

    public int getMAX_BATCH_SIZE() {
        return this.MAX_BATCH_SIZE;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setMapperName(String mapperName) {
        this.mapperName = mapperName;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchDaoService)) {
            return false;
        }
        BatchDaoService other = (BatchDaoService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMAX_BATCH_SIZE() != other.getMAX_BATCH_SIZE()) {
            return false;
        }
        SqlSessionFactory this$sqlSessionFactory = this.getSqlSessionFactory();
        SqlSessionFactory other$sqlSessionFactory = other.getSqlSessionFactory();
        if (this$sqlSessionFactory == null ? other$sqlSessionFactory != null : !this$sqlSessionFactory.equals(other$sqlSessionFactory)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$mapperName = this.getMapperName();
        String other$mapperName = other.getMapperName();
        if (this$mapperName == null ? other$mapperName != null : !this$mapperName.equals(other$mapperName)) {
            return false;
        }
        String this$mapper = this.getMapper();
        String other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchDaoService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMAX_BATCH_SIZE();
        SqlSessionFactory $sqlSessionFactory = this.getSqlSessionFactory();
        result = result * 59 + ($sqlSessionFactory == null ? 43 : $sqlSessionFactory.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $mapperName = this.getMapperName();
        result = result * 59 + ($mapperName == null ? 43 : $mapperName.hashCode());
        String $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        result = result * 59 + this.getCount();
        return result;
    }

    public String toString() {
        return "BatchDaoService(MAX_BATCH_SIZE=" + this.getMAX_BATCH_SIZE() + ", sqlSessionFactory=" + this.getSqlSessionFactory() + ", serviceName=" + this.getServiceName() + ", mapperName=" + this.getMapperName() + ", mapper=" + this.getMapper() + ", count=" + this.getCount() + ")";
    }
}

