/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPProcessingException;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.AxiomSoapFaultDetail;
import org.springframework.ws.soap.axiom.AxiomSoapFaultException;

abstract class AxiomSoapFault
extends AxiomSoapElement
implements SoapFault {
    protected AxiomSoapFault(SOAPFault axiomFault, SOAPFactory axiomFactory) {
        super((OMElement)axiomFault, axiomFactory);
    }

    @Override
    public String getFaultActorOrRole() {
        SOAPFaultRole faultRole = this.getAxiomFault().getRole();
        return faultRole != null ? faultRole.getRoleValue() : null;
    }

    @Override
    public void setFaultActorOrRole(String actor) {
        try {
            SOAPFaultRole axiomFaultRole = this.getAxiomFactory().createSOAPFaultRole(this.getAxiomFault());
            axiomFaultRole.setRoleValue(actor);
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    @Override
    public SoapFaultDetail getFaultDetail() {
        try {
            SOAPFaultDetail axiomFaultDetail = this.getAxiomFault().getDetail();
            return axiomFaultDetail != null ? new AxiomSoapFaultDetail(axiomFaultDetail, this.getAxiomFactory()) : null;
        }
        catch (OMException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    @Override
    public SoapFaultDetail addFaultDetail() {
        try {
            SOAPFaultDetail axiomFaultDetail = this.getAxiomFactory().createSOAPFaultDetail(this.getAxiomFault());
            return new AxiomSoapFaultDetail(axiomFaultDetail, this.getAxiomFactory());
        }
        catch (OMException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    protected SOAPFault getAxiomFault() {
        return (SOAPFault)this.getAxiomElement();
    }
}

