/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.webapp.security;

import com.its.app.webapp.service.UserService;
import com.its.app.webapp.vo.voUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class UserAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationProvider.class);
    private final UserService userService;

    public UserAuthenticationProvider(UserService userService) {
        this.userService = userService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String id = authentication.getName();
        String password = (String)authentication.getCredentials();
        voUser user = this.userService.loadUserByUsername(id);
        if (user == null) {
            throw new BadCredentialsException("Login Error !!");
        }
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)id, (Object)password, user.getAuthorities());
        result.setDetails((Object)user);
        return result;
    }

    public boolean supports(Class authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

