/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.xnetudp;

import com.its.app.config.AbstractServerConfig;
import com.its.app.config.AppUtils;
import com.its.app.xnetudp.UdpServerAbstract;
import com.its.app.xnetudp.codec.CenterCommServerDecoder;
import com.its.app.xnetudp.handler.CenterCommServerPacketHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UdpServerCenterComm
extends UdpServerAbstract {
    private static final Logger log = LoggerFactory.getLogger(UdpServerCenterComm.class);
    private AbstractServerConfig serverConfig;

    @PostConstruct
    private void init() {
        this.serverConfig = (AbstractServerConfig)AppUtils.getBean(AbstractServerConfig.class);
    }

    public void run() {
        block7: {
            log.info("UdpServerCenterComm.init: Start.");
            try {
                this.nioEventLoopGroup = new NioEventLoopGroup();
                this.bootstrap = new Bootstrap();
                this.bootstrap.channel(NioDatagramChannel.class);
                this.bootstrap.group(this.nioEventLoopGroup);
                this.bootstrap.option(ChannelOption.SO_BROADCAST, (Object)true);
                this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
                this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel channel) throws Exception {
                        channel.pipeline().addLast("centerCommServerDecoder", (ChannelHandler)new CenterCommServerDecoder());
                        channel.pipeline().addLast("centerCommServerPacketHandler", (ChannelHandler)new CenterCommServerPacketHandler());
                    }
                });
            }
            catch (Exception e) {
                log.error("UdpServerCenterComm.init: Exception: {}", (Object)e.toString());
            }
            log.info("===============================================================");
            log.info("=  UDP Center Communication Server Start.......................");
            log.info("=  bindAddress: {}", (Object)this.serverConfig.getCenterBindAddr());
            log.info("=     bindPort: {}", (Object)this.serverConfig.getCenterBindPort());
            log.info("===============================================================");
            try {
                if (this.serverConfig.getCenterBindAddr().equals("0.0.0.0")) {
                    this.bootstrap.bind(this.serverConfig.getCenterBindPort());
                    break block7;
                }
                this.bootstrap.bind(this.serverConfig.getCenterBindAddr(), this.serverConfig.getCenterBindPort());
            }
            catch (Exception e) {
                log.error("UdpServerCenterComm.init: Bind Exception: {}", (Object)e.toString());
                this.nioEventLoopGroup.shutdownGracefully();
            }
        }
        log.info("UdpServerCenterComm.init: ..End. {}", (Object)this.toString());
    }

    public String toString() {
        return "UdpServerCenterComm(serverConfig=" + this.serverConfig + ")";
    }
}

