/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server;

import com.utic.center.common.spring.SpringUtils;
import com.utic.center.common.utils.ApplicationUtils;
import com.utic.center.utic.stat.server.config.ApplicationConfig;
import com.utic.center.utic.stat.server.service.ProcessStateService;
import com.utic.center.utic.stat.server.service.UticStatPrepareService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"com.utic.center.common.spring", "com.utic.center.utic.stat.server.config", "com.utic.center.utic.stat.server", "com.utic.center.common.aspect"})
public class UticStatServerApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UticStatServerApplication.class);
    private static boolean isTerminal = false;
    public static final String APPLICATION_NAME = "utic-stat-server";

    public static void main(String[] args) {
        Path pidPath = ApplicationUtils.getApplicationPidPath(UticStatServerApplication.class, (String)APPLICATION_NAME);
        if (ApplicationUtils.isRunning((Path)pidPath)) {
            log.warn("[WAN] UticStatServerApplication is already running. Check the PID file: {}", (Object)pidPath);
            System.exit(1);
        }
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{UticStatServerApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/utic-stat-server.pid")}).registerShutdownHook(true).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                        UTIC Center DWDB System                                 **");
        log.info("**          UTIC Center DWDB Statistics Processing Server Program.                **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        ApplicationConfig applicationConfig = (ApplicationConfig)SpringUtils.getBean(ApplicationConfig.class);
        applicationConfig.setStartSchedule(false);
        ProcessStateService processStateService = (ProcessStateService)SpringUtils.getBean(ProcessStateService.class);
        processStateService.processStart();
        UticStatPrepareService prepareService = (UticStatPrepareService)SpringUtils.getBean(UticStatPrepareService.class);
        prepareService.processing();
        applicationConfig.setStartSchedule(true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.error("on shutdown hook.");
            this.terminate();
            try {
                Path pidPath = ApplicationUtils.getApplicationPidPath(UticStatServerApplication.class, (String)APPLICATION_NAME);
                Files.deleteIfExists(pidPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    public void terminate() {
        if (!isTerminal) {
            isTerminal = true;
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            log.error("************************************************************************************");
            log.error("**    Application Terminated: {}", (Object)sdfDate.format(new Date()));
            try {
                ApplicationConfig applicationConfig = (ApplicationConfig)SpringUtils.getBean(ApplicationConfig.class);
                applicationConfig.setStartSchedule(false);
                ProcessStateService processStateService = (ProcessStateService)SpringUtils.getBean(ProcessStateService.class);
                processStateService.processStop();
            }
            catch (Exception e) {
                log.error("**    Application Terminated: {}", (Object)e.getMessage());
            }
            log.error("************************************************************************************");
        }
    }

    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        log.error("{}", (Object)contextClosedEvent);
        this.terminate();
    }

    public void destroy() throws Exception {
        log.error("Application destroy");
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Application afterPropertiesSet");
    }
}

