/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.dto.ProcessStateDto;
import com.utic.center.utic.stat.server.config.ApplicationConfig;
import com.utic.center.utic.stat.server.dao.repository.ProcessRepository;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ProcessStateService {
    private static final Logger log = LoggerFactory.getLogger(ProcessStateService.class);
    private final ProcessRepository repo;
    private final ApplicationConfig config;

    @PostConstruct
    private void init() {
        log.info("ProcessStateService.init: start.");
        log.info("ProcessStateService.init. processId: {}.", (Object)this.config.getProcessId());
        log.info("ProcessStateService.init: ..end.");
    }

    @PreDestroy
    public void destroyService() {
        log.error("ProcessStateService.destroy. system terminated.......");
        this.processStop();
    }

    public void processStop() {
        ApplicationRepository.processState.setRunState(ProcessStateDto.RUN_STATE.STOP.getValue());
        this.updateProcessState(false);
    }

    public void processStart() {
        ApplicationRepository.processState.setRunState(ProcessStateDto.RUN_STATE.NORMAL.getValue());
        this.updateProcessState(true);
    }

    public void processRunning() {
        this.processStart();
    }

    private void updateProcessState(boolean isRun) {
        this.repo.updateProcessState(ApplicationRepository.processState);
    }

    public ProcessRepository getRepo() {
        return this.repo;
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public ProcessStateService(ProcessRepository repo, ApplicationConfig config) {
        this.repo = repo;
        this.config = config;
    }
}

