/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.annotation.ProcessingElapsed;
import com.utic.center.common.service.AbstractProcessService;
import com.utic.center.common.utils.TimeUtils;
import com.utic.center.utic.stat.server.dao.repository.UticStat04MinEtlpRepository;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UticStat04MinEtlpService
implements AbstractProcessService {
    private static final Logger log = LoggerFactory.getLogger(UticStat04MinEtlpService.class);
    private final UticStat04MinEtlpRepository etlpRepo;
    private String past10Min;

    private void initialize() {
        LocalDateTime now = LocalDateTime.now();
        int year = now.getYear();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        int hour = now.getHour();
        int minute = now.getMinute();
        String prcsTime = String.format("%04d%02d%02d%02d%02d00", year, month, day, hour, minute);
        this.past10Min = TimeUtils.addMinutes((String)prcsTime, (int)-10);
    }

    @ProcessingElapsed(type="ETLP", name="\uad50\ud1b5\uc815\ubcf4 \uc774\uad00 \uc791\uc5c5", starting=false)
    public boolean processing() {
        this.initialize();
        this.etlpRepo.insertRcvLinkTraffic(this.past10Min);
        return true;
    }

    public UticStat04MinEtlpRepository getEtlpRepo() {
        return this.etlpRepo;
    }

    public String getPast10Min() {
        return this.past10Min;
    }

    public UticStat04MinEtlpService(UticStat04MinEtlpRepository etlpRepo) {
        this.etlpRepo = etlpRepo;
    }
}

