/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.scheduler;

import com.utic.center.utic.stat.server.config.ApplicationConfig;
import com.utic.center.utic.stat.server.controller.UticStatServerController;
import com.utic.center.utic.stat.server.service.ProcessStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class UticStatServerScheduler {
    private static final Logger log = LoggerFactory.getLogger(UticStatServerScheduler.class);
    private final ApplicationConfig config;
    private final ProcessStateService processStateService;
    private final UticStatServerController controller;

    @Scheduled(cron="0 * * * * *")
    public void scheduleProcess() {
        if (this.config.isStartSchedule()) {
            try {
                this.controller.run();
            }
            catch (Exception e) {
                log.error("ApplicationScheduler.scheduleProcess: Exception {}", (Object)e.getMessage());
            }
            try {
                this.processStateService.processRunning();
            }
            catch (Exception e) {
                log.error("ApplicationScheduler.updateProcessState: Exception {}", (Object)e.getMessage());
            }
        }
    }

    public UticStatServerScheduler(ApplicationConfig config, ProcessStateService processStateService, UticStatServerController controller) {
        this.config = config;
        this.processStateService = processStateService;
        this.controller = controller;
    }
}

