/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.annotation.ProcessingElapsed;
import com.utic.center.common.service.AbstractProcessService;
import com.utic.center.common.utils.LogUtils;
import com.utic.center.utic.stat.server.dao.repository.UticStat05MinFltrRepository;
import com.utic.center.utic.stat.server.dao.repository.UticStatPatternRepository;
import com.utic.center.utic.stat.server.dto.CodeValueDto;
import com.utic.center.utic.stat.server.dto.HolidayDto;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import com.utic.center.utic.stat.server.service.UticStatParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UticStat05MinFltrService
implements AbstractProcessService {
    private static final Logger log = LoggerFactory.getLogger(UticStat05MinFltrService.class);
    private final UticStatParamService paramService;
    private final UticStat05MinFltrRepository fltrRepo;
    private final UticStatPatternRepository patternRepo;

    @ProcessingElapsed(type="05MIN", name="\uc815\uc8fc\uae30 5\ubd84 \ub9c1\ud06c\ud544\ud130 \uc0dd\uc131", starting=false)
    public boolean processing() {
        String past25Min = ApplicationRepository.past25Min;
        String past30Min = ApplicationRepository.past30Min;
        log.info("[INF] {}: past25Min[{}], past30Min[{}]", new Object[]{LogUtils.elapsedLog((String)"05\ubd84 \ub9c1\ud06c\ud544\ud130"), past25Min, past30Min});
        CodeValueDto code0 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_00);
        CodeValueDto code1 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_01);
        CodeValueDto code2 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_02);
        CodeValueDto code5 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_05);
        CodeValueDto code6 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_06);
        CodeValueDto code7 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_07);
        CodeValueDto code8 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_08);
        CodeValueDto code9 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_09);
        this.fltrRepo.truncateStatLocal();
        this.fltrRepo.insertStatLocalRcvLinkTraffic(past25Min, past30Min);
        this.fltrRepo.truncateLinkFilter();
        this.fltrRepo.insertLinkFilterStdDev(past25Min, code0.getCodeValue(), code5.getCodeValue());
        if ("Y".equals(code1.getCodeValue())) {
            log.info("[INF] {}: LINK_FILTER \ud1b5\uacc4 \ucd5c\ub300\ucd5c\uc18c \ud544\ud130\ub9c1 \uc0ac\uc6a9", (Object)LogUtils.elapsedLog((String)"LINK_FILTER(\ud328\ud134 \ud544\ud130\ub9c1)"));
            HolidayDto holiday = this.patternRepo.findHoliday(past25Min);
            if (holiday != null) {
                this.runLinkFilterPatternUpdate(past25Min, holiday, code2);
            }
        } else {
            log.info("[INF] {}: LINK_FILTER \ud1b5\uacc4 \ucd5c\ub300\ucd5c\uc18c \ud544\ud130\ub9c1 \uc0ac\uc6a9\uc548\ud568", (Object)LogUtils.elapsedLog((String)"LINK_FILTER(\ud328\ud134 \ud544\ud130\ub9c1)"));
        }
        this.fltrRepo.updateLinkFilterRoadRank();
        if ("Y".equals(code2.getCodeValue())) {
            log.info("[INF] {}: LINK_FILTER \ub3c4\ub85c\ub4f1\uae09 \ucd5c\ub300\ucd5c\uc18c \ud544\ud130\ub9c1 \uc0ac\uc6a9", (Object)LogUtils.elapsedLog((String)"LINK_FILTER(\ub3c4\ub85c\ub4f1\uae09 \ud544\ud130\ub9c1)"));
            this.fltrRepo.updateLinkFilterMinMax(code6.getMinValue(), code6.getMaxValue(), code7.getMinValue(), code7.getMaxValue(), code8.getMinValue(), code8.getMaxValue(), code9.getMinValue(), code9.getMaxValue());
        } else {
            log.info("[INF] {}: LINK_FILTER \ub3c4\ub85c\ub4f1\uae09 \ucd5c\ub300\ucd5c\uc18c \ud544\ud130\ub9c1 \uc0ac\uc6a9\uc548\ud568", (Object)LogUtils.elapsedLog((String)"LINK_FILTER(\ub3c4\ub85c\ub4f1\uae09 \ud544\ud130\ub9c1)"));
        }
        this.fltrRepo.insertStatLocalLog();
        return true;
    }

    private void runLinkFilterPatternUpdate(String prcsPast25Min, HolidayDto holiday, CodeValueDto codeValue2) {
        String fromTable;
        String logTable;
        if (holiday.getHCnt() > 0) {
            logTable = "(\ud734\uc77c)PATN_HOLIDAY";
            fromTable = "PATN_HOLIDAY";
        } else {
            switch (holiday.getWDay()) {
                case 1: {
                    logTable = "(\uc77c\uc694\uc77c)PATN_SUN";
                    fromTable = "PATN_SUN";
                    break;
                }
                case 2: {
                    logTable = "(\uc6d4\uc694\uc77c)PATN_MON";
                    fromTable = "PATN_MON";
                    break;
                }
                case 6: {
                    logTable = "(\uae08\uc694\uc77c)PATN_FRI";
                    fromTable = "PATN_FRI";
                    break;
                }
                case 7: {
                    logTable = "(\ud1a0\uc694\uc77c)PATN_SAT";
                    fromTable = "PATN_SAT";
                    break;
                }
                default: {
                    logTable = "(\ud3c9\uc77c)PATN_WEEK";
                    fromTable = "PATN_WEEK";
                }
            }
        }
        this.fltrRepo.updateLinkFilterPattern(fromTable, prcsPast25Min, codeValue2.getMinValue(), codeValue2.getMaxValue(), logTable);
        this.fltrRepo.updateLinkFilterSpeedNull();
    }

    public UticStatParamService getParamService() {
        return this.paramService;
    }

    public UticStat05MinFltrRepository getFltrRepo() {
        return this.fltrRepo;
    }

    public UticStatPatternRepository getPatternRepo() {
        return this.patternRepo;
    }

    public UticStat05MinFltrService(UticStatParamService paramService, UticStat05MinFltrRepository fltrRepo, UticStatPatternRepository patternRepo) {
        this.paramService = paramService;
        this.fltrRepo = fltrRepo;
        this.patternRepo = patternRepo;
    }
}

