/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.controller;

import com.utic.center.common.utils.LogUtils;
import com.utic.center.common.utils.TimeUtils;
import com.utic.center.utic.stat.server.config.ApplicationConfig;
import com.utic.center.utic.stat.server.dto.BatchJobInfoDto;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
public class UticStatServerRestController {
    private final ApplicationConfig config;

    @GetMapping(value={"/info"}, produces={"application/json; charset=utf8"})
    public String stringInfo() {
        String sep = System.lineSeparator();
        String heading = "------------------------------------------------------------------------------------------------------------";
        StringBuilder sb = new StringBuilder();
        sb.append(heading).append(sep);
        sb.append("UTIC Center DWDB Statistics Processing Server").append(sep);
        sb.append(heading).append(sep);
        sb.append(String.format("Process Id: %s, %s, %s", this.config.getProcessId(), this.config.getBootingTime(), TimeUtils.now())).append(sep);
        sb.append(heading).append(sep);
        sb.append(String.format("%s %-20.20s %-20.20s    TOTAL  04_ETLP  05_FLTR  05_STAT  15_STAT  01_PTRN", " SEQ", "Start", "End")).append(sep);
        sb.append(heading).append(sep);
        int total = 0;
        int jobSize = ApplicationRepository.batchJobInfoList.size();
        for (int ii = jobSize - 1; ii >= 0; --ii) {
            BatchJobInfoDto jobInfo = (BatchJobInfoDto)ApplicationRepository.batchJobInfoList.get(ii);
            sb.append(String.format("%4d %-20.20s %-20.20s %s %s %s %s %s %s", ++total, jobInfo.getStartTime(), jobInfo.getEndTime(), LogUtils.numberLog((long)jobInfo.getElapsedTime()), LogUtils.numberLog((long)jobInfo.getEtlp04MinTime()), LogUtils.numberLog((long)jobInfo.getFltr05MinTime()), LogUtils.numberLog((long)jobInfo.getStat05MinTime()), LogUtils.numberLog((long)jobInfo.getStat15MinTime()), LogUtils.numberLog((long)jobInfo.getPtrnInitTime()))).append(sep);
        }
        sb.append(heading).append(sep);
        return sb.toString();
    }

    public UticStatServerRestController(ApplicationConfig config) {
        this.config = config;
    }
}

