/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.annotation.ProcessingElapsed;
import com.utic.center.common.service.AbstractProcessService;
import com.utic.center.common.utils.LogUtils;
import com.utic.center.utic.stat.server.dao.repository.UticStatPatternRepository;
import com.utic.center.utic.stat.server.dto.CodeValueDto;
import com.utic.center.utic.stat.server.dto.HolidayDto;
import com.utic.center.utic.stat.server.dto.PatternDto;
import com.utic.center.utic.stat.server.dto.PatternJobDto;
import com.utic.center.utic.stat.server.service.UticStatParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UticStatPatternService
implements AbstractProcessService {
    private static final Logger log = LoggerFactory.getLogger(UticStatPatternService.class);
    private final UticStatParamService paramService;
    private final UticStatPatternRepository patternRepo;

    @ProcessingElapsed(type="1HOUR", name="\uc815\uc8fc\uae30 1\uc2dc\uac04 \ud328\ud134\ucd08\uae30\ud654", starting=false)
    public boolean processing() {
        PatternDto pattern = this.patternRepo.findPatternDay();
        if (pattern == null) {
            return false;
        }
        log.info("[INF] {}: patternExeDay[{}], weekDay[{}], workWeek[1,2]", new Object[]{LogUtils.elapsedLog((String)"PATTERN"), pattern.getExeDay(), pattern.getWeekDay()});
        if (pattern.getWeekDay() == 1) {
            this.patternInitialize("0", pattern.getExeDay());
        } else if (pattern.getWeekDay() == 2) {
            this.patternInitialize("1", pattern.getExeDay());
        }
        return true;
    }

    private void patternInitialize(String patternType, String exeDay) {
        PatternJobDto patternJobLog = this.patternRepo.findPatternJobLog(patternType, exeDay);
        if (patternJobLog == null || patternJobLog.getJobCount() >= 1) {
            return;
        }
        this.patternRepo.insertPatternJobLog(patternType, exeDay);
        if ("0".equals(patternType)) {
            this.patternRepo.deletePatternWeekJob();
        } else {
            this.patternRepo.deletePattern15MinWeekJob();
        }
        this.patternRepo.updatePatternJobLog(patternType, exeDay);
    }

    public void patternUpdate(String patternTime, boolean is05Min) {
        String mergeTable;
        String fromTable;
        String logTable;
        String tablePrifix = is05Min ? "PATN_" : "PATN_15MIN_";
        String minValue = "0";
        String maxValue = "0";
        String columnName = "SPEED3";
        CodeValueDto code11 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_11);
        CodeValueDto code12 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_12);
        CodeValueDto code13 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_13);
        CodeValueDto code14 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_14);
        CodeValueDto code15 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_15);
        CodeValueDto code16 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_16);
        boolean isWeek = false;
        HolidayDto holiday = null;
        holiday = this.patternRepo.findHoliday(patternTime);
        if (holiday == null) {
            log.error("[ERR] {}, findHoliday[{}], {} \ud734\uc77c\uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", new Object[]{LogUtils.elapsedLog((String)"HOLIDAY"), patternTime, is05Min ? "05MIN" : "15MIN"});
            return;
        }
        if (holiday.getHCnt() > 0) {
            logTable = tablePrifix + "HOLIDAY(\ud734\uc77c)";
            fromTable = tablePrifix + "HOLIDAY";
            minValue = String.valueOf(code16.getMinValue());
            maxValue = String.valueOf(code16.getMaxValue());
        } else {
            switch (holiday.getWDay()) {
                case 1: {
                    logTable = tablePrifix + "SUN(\uc77c\uc694\uc77c)";
                    fromTable = tablePrifix + "SUN";
                    minValue = String.valueOf(code11.getMinValue());
                    maxValue = String.valueOf(code11.getMaxValue());
                    break;
                }
                case 2: {
                    logTable = tablePrifix + "MON(\uc6d4\uc694\uc77c)";
                    fromTable = tablePrifix + "MON";
                    minValue = String.valueOf(code12.getMinValue());
                    maxValue = String.valueOf(code12.getMaxValue());
                    break;
                }
                case 6: {
                    logTable = tablePrifix + "FRI(\uae08\uc694\uc77c)";
                    fromTable = tablePrifix + "FRI";
                    minValue = String.valueOf(code14.getMinValue());
                    maxValue = String.valueOf(code14.getMaxValue());
                    break;
                }
                case 7: {
                    logTable = tablePrifix + "SAT(\ud1a0\uc694\uc77c)";
                    fromTable = tablePrifix + "SAT";
                    minValue = String.valueOf(code15.getMinValue());
                    maxValue = String.valueOf(code15.getMaxValue());
                    break;
                }
                default: {
                    isWeek = true;
                    logTable = tablePrifix + "WEEK(\ud3c9\uc77c)";
                    fromTable = tablePrifix + "WEEK";
                    columnName = holiday.getWDay() == 3 ? "SPEED3" : (holiday.getWDay() == 4 ? "SPEED4" : "SPEED5");
                }
            }
        }
        this.patternRepo.insertPatternHist(fromTable + "_HIST", fromTable, patternTime, logTable);
        String targetTable = is05Min ? "PATN_WEEK_JOB" : "PATN_15MIN_WEEK_JOB";
        String statTable = is05Min ? "STAT_5MIN_CENTER" : "STAT_15MIN_CENTER";
        String string = mergeTable = is05Min ? "PATN_WEEK" : "PATN_15MIN_WEEK";
        if (isWeek) {
            this.patternRepo.mergePatternWeekJob(targetTable, statTable, columnName, patternTime, holiday.getWDay().toString());
        } else {
            this.patternRepo.updatePattern(fromTable, statTable, patternTime, minValue, maxValue, logTable);
        }
        if (holiday.getWDay() == 6) {
            minValue = String.valueOf(code13.getMinValue());
            maxValue = String.valueOf(code13.getMaxValue());
            this.patternRepo.mergePatternWeek(mergeTable, targetTable, patternTime, minValue, maxValue);
        }
    }

    public UticStatParamService getParamService() {
        return this.paramService;
    }

    public UticStatPatternRepository getPatternRepo() {
        return this.patternRepo;
    }

    public UticStatPatternService(UticStatParamService paramService, UticStatPatternRepository patternRepo) {
        this.paramService = paramService;
        this.patternRepo = patternRepo;
    }
}

