/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.config;

import com.utic.center.common.utils.TimeUtils;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application")
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private String processName = "utic-stat-server";
    private String processId = "70040";
    private int errTimeGap = 120;
    private int prcsThreadCount = 10;
    private int dbmsBatchSize = 1000;
    private String bootingTime;
    private boolean startSchedule;

    @PostConstruct
    private void init() {
        this.startSchedule = false;
        this.bootingTime = TimeUtils.now();
        if (this.dbmsBatchSize <= 1000) {
            this.dbmsBatchSize = 1000;
        }
        this.dbmsBatchSize = Math.min(this.dbmsBatchSize, 2000);
        ApplicationRepository.processState.setProcessId(this.processId);
        ApplicationRepository.processState.setErrTimeGap(Integer.valueOf(this.getErrTimeGap()));
        log.info("[{}] -------------------------", (Object)this.getClass().getSimpleName());
        log.info("{}", (Object)super.toString());
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public int getErrTimeGap() {
        return this.errTimeGap;
    }

    public int getPrcsThreadCount() {
        return this.prcsThreadCount;
    }

    public int getDbmsBatchSize() {
        return this.dbmsBatchSize;
    }

    public String getBootingTime() {
        return this.bootingTime;
    }

    public boolean isStartSchedule() {
        return this.startSchedule;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setErrTimeGap(int errTimeGap) {
        this.errTimeGap = errTimeGap;
    }

    public void setPrcsThreadCount(int prcsThreadCount) {
        this.prcsThreadCount = prcsThreadCount;
    }

    public void setDbmsBatchSize(int dbmsBatchSize) {
        this.dbmsBatchSize = dbmsBatchSize;
    }

    public void setBootingTime(String bootingTime) {
        this.bootingTime = bootingTime;
    }

    public void setStartSchedule(boolean startSchedule) {
        this.startSchedule = startSchedule;
    }
}

