/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.annotation.ProcessingElapsed;
import com.utic.center.common.service.AbstractProcessService;
import com.utic.center.common.utils.LogUtils;
import com.utic.center.utic.stat.server.dao.repository.UticStat15MinStatRepository;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import com.utic.center.utic.stat.server.service.UticStatPatternService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UticStat15MinStatService
implements AbstractProcessService {
    private static final Logger log = LoggerFactory.getLogger(UticStat15MinStatService.class);
    private final UticStat15MinStatRepository statRepo;
    private final UticStatPatternService patternService;

    @ProcessingElapsed(type="15MIN", name="\uc815\uc8fc\uae30 15\ubd84 \ud1b5\uacc4\uc0dd\uc131", starting=false)
    public boolean processing() {
        String past30Min = ApplicationRepository.past30Min.substring(0, 12);
        String past45Min = ApplicationRepository.past45Min.substring(0, 12);
        String regDate = ApplicationRepository.past30Min;
        log.info("[INF] {}: past30Min[{}], past45Min[{}], patternTime[{}]", new Object[]{LogUtils.elapsedLog((String)"15\ubd84 \ud1b5\uacc4\uc2dc\uac01"), past30Min, past45Min, regDate});
        this.statRepo.insertStat15MinCenter(past30Min, past45Min);
        this.statRepo.insertStat15MinLoc(past30Min, past45Min);
        this.patternService.patternUpdate(regDate, false);
        return false;
    }

    public UticStat15MinStatRepository getStatRepo() {
        return this.statRepo;
    }

    public UticStatPatternService getPatternService() {
        return this.patternService;
    }

    public UticStat15MinStatService(UticStat15MinStatRepository statRepo, UticStatPatternService patternService) {
        this.statRepo = statRepo;
        this.patternService = patternService;
    }
}

