/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.controller;

import com.utic.center.common.utils.LogUtils;
import com.utic.center.common.utils.TimeUtils;
import com.utic.center.utic.stat.server.dto.BatchJobInfoDto;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import com.utic.center.utic.stat.server.service.UticStat04MinEtlpService;
import com.utic.center.utic.stat.server.service.UticStat05MinFltrService;
import com.utic.center.utic.stat.server.service.UticStat05MinStatService;
import com.utic.center.utic.stat.server.service.UticStat15MinStatService;
import com.utic.center.utic.stat.server.service.UticStatPatternService;
import com.utic.center.utic.stat.server.service.UticStatPrepareService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class UticStatServerController {
    private static final Logger log = LoggerFactory.getLogger(UticStatServerController.class);
    private final UticStatPrepareService prepareService;
    private final UticStat04MinEtlpService etlp04MinService;
    private final UticStat05MinFltrService fltr05MinService;
    private final UticStat05MinStatService stat05MinService;
    private final UticStat15MinStatService stat15MinService;
    private final UticStatPatternService patternService;
    private long etlpElapsed = 0L;
    private long dayElapsed = 0L;
    private String prevPrcsTime = "";
    private boolean isRunning = false;
    private boolean isEtlp = false;
    private boolean is05Min = false;
    private boolean is15Min = false;
    private boolean is30Min = false;
    private boolean isHour = false;
    private boolean isDay = false;

    private void calculateTime() {
        LocalDateTime now = LocalDateTime.now();
        int hour = now.getHour();
        int minute = now.getMinute();
        this.isEtlp = (minute + 1) % 5 == 0;
        this.is05Min = minute % 5 == 0;
        this.is15Min = minute % 15 == 0;
        this.is30Min = minute % 30 == 0;
        this.isHour = minute == 0;
        this.isDay = hour == 0 && minute == 0;
    }

    private void initialize() {
        LocalDateTime now = LocalDateTime.now();
        int year = now.getYear();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        int hour = now.getHour();
        int minute = now.getMinute();
        String prcsTime = String.format("%04d%02d%02d%02d%02d00", year, month, day, hour, minute);
        ApplicationRepository.past10Min = TimeUtils.addMinutes((String)prcsTime, (int)-10);
        ApplicationRepository.past25Min = TimeUtils.addMinutes((String)prcsTime, (int)-25);
        ApplicationRepository.past30Min = TimeUtils.addMinutes((String)prcsTime, (int)-30);
        ApplicationRepository.past45Min = TimeUtils.addMinutes((String)prcsTime, (int)-45);
        ApplicationRepository.past60Min = TimeUtils.addMinutes((String)prcsTime, (int)-60);
        ApplicationRepository.past90Min = TimeUtils.addMinutes((String)prcsTime, (int)-90);
        ApplicationRepository.past120Min = TimeUtils.addMinutes((String)prcsTime, (int)-120);
        ApplicationRepository.regDate = ApplicationRepository.past25Min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String header = "==========================================================================================================";
        String step = "----------------------------------------------------------------------------------------------------------";
        String completed = "**********************************************************************************************************";
        long start = System.currentTimeMillis();
        this.calculateTime();
        if (this.isEtlp) {
            this.isRunning = true;
            this.etlp04MinService.processing();
            this.prepareService.processing();
            this.isRunning = false;
            this.etlpElapsed = System.currentTimeMillis() - start;
            return;
        }
        if (!this.is05Min) {
            return;
        }
        log.info("==========================================================================================================");
        if (this.isRunning) {
            log.warn("[WAN] {}: [{}] - Already running.", (Object)LogUtils.elapsedLog((String)"Overlapping"), (Object)this.prevPrcsTime);
        }
        this.isRunning = true;
        this.prevPrcsTime = TimeUtils.getCurrentTimeString();
        log.info("##>> 05MIN {}: [{}]", (Object)LogUtils.elapsedLogLength((String)"\uc815\uc8fc\uae30 \uad50\ud1b5\uc815\ubcf4 \ud1b5\uacc4 Start", (int)5), (Object)this.prevPrcsTime);
        BatchJobInfoDto jobInfo = new BatchJobInfoDto(TimeUtils.now());
        jobInfo.setEtlp04MinTime(this.etlpElapsed);
        jobInfo.setStat01MonthTime(this.dayElapsed);
        try {
            this.initialize();
            long tmpStart = System.currentTimeMillis();
            this.fltr05MinService.processing();
            jobInfo.setFltr05MinTime(System.currentTimeMillis() - tmpStart);
            log.info("----------------------------------------------------------------------------------------------------------");
            tmpStart = System.currentTimeMillis();
            this.stat05MinService.processing();
            jobInfo.setStat05MinTime(System.currentTimeMillis() - tmpStart);
            log.info("----------------------------------------------------------------------------------------------------------");
            if (this.is15Min) {
                tmpStart = System.currentTimeMillis();
                this.stat15MinService.processing();
                jobInfo.setStat15MinTime(System.currentTimeMillis() - tmpStart);
                log.info("----------------------------------------------------------------------------------------------------------");
            }
            if (this.is30Min) {
                // empty if block
            }
            if (this.isHour) {
                tmpStart = System.currentTimeMillis();
                this.patternService.processing();
                jobInfo.setPtrnInitTime(System.currentTimeMillis() - tmpStart);
                log.info("----------------------------------------------------------------------------------------------------------");
            }
            if (this.isDay) {
                // empty if block
            }
        }
        finally {
            this.isRunning = false;
        }
        long executionTime = System.currentTimeMillis() - start;
        jobInfo.setEndTime(TimeUtils.now());
        jobInfo.setElapsedTime(executionTime);
        ApplicationRepository.addJobInfo((BatchJobInfoDto)jobInfo);
        log.info("<<## 05MIN {} [{}].", (Object)LogUtils.elapsedLogLength((String)"\uc815\uc8fc\uae30 \uad50\ud1b5\uc815\ubcf4 \ud1b5\uacc4 End", (long)executionTime, (int)5), (Object)this.prevPrcsTime);
        log.info("**********************************************************************************************************");
    }

    public UticStatServerController(UticStatPrepareService prepareService, UticStat04MinEtlpService etlp04MinService, UticStat05MinFltrService fltr05MinService, UticStat05MinStatService stat05MinService, UticStat15MinStatService stat15MinService, UticStatPatternService patternService) {
        this.prepareService = prepareService;
        this.etlp04MinService = etlp04MinService;
        this.fltr05MinService = fltr05MinService;
        this.stat05MinService = stat05MinService;
        this.stat15MinService = stat15MinService;
        this.patternService = patternService;
    }
}

