/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.dao.repository;

import com.utic.center.common.annotation.SqlOperation;
import com.utic.center.utic.stat.server.dao.mapper.UticStatPatternMapper;
import com.utic.center.utic.stat.server.dto.HolidayDto;
import com.utic.center.utic.stat.server.dto.PatternDto;
import com.utic.center.utic.stat.server.dto.PatternJobDto;
import org.springframework.stereotype.Repository;

@Repository
public class UticStatPatternRepository {
    private final UticStatPatternMapper mapper;

    @SqlOperation(type=SqlOperation.SqlType.SELECT, table="HOLIDAY", param="past25Min")
    public HolidayDto findHoliday(String patternTime) {
        return this.mapper.findHoliday(patternTime);
    }

    @SqlOperation(type=SqlOperation.SqlType.INSERT, table="PATTERN_HIST", param="targetTable", param2="logTable")
    public int insertPatternHist(String targetTable, String fromTable, String patternTime, String logTable) {
        return this.mapper.insertPatternHist(targetTable, fromTable, patternTime);
    }

    @SqlOperation(type=SqlOperation.SqlType.MERGE, table="PATTERN_UPDATE", param="targetTable", param2="logTable")
    public int updatePattern(String targetTable, String statTable, String patternTime, String minValue, String maxValue, String logTable) {
        return this.mapper.updatePattern(targetTable, statTable, patternTime, minValue, maxValue);
    }

    @SqlOperation(type=SqlOperation.SqlType.MERGE, table="PATTERN_WEEK", param="targetTable")
    public int mergePatternWeekJob(String targetTable, String statTable, String columnName, String patternTime, String weekType) {
        return this.mapper.mergePatternWeekJob(targetTable, statTable, columnName, patternTime, weekType);
    }

    @SqlOperation(type=SqlOperation.SqlType.MERGE, table="PATTERN_WEEK", param="targetTable")
    public int mergePatternWeek(String targetTable, String jobTable, String patternTime, String minValue, String maxValue) {
        return this.mapper.mergePatternWeek(targetTable, jobTable, patternTime, minValue, maxValue);
    }

    @SqlOperation(type=SqlOperation.SqlType.SELECT, table="DUAL", param="PATTERN DAY, WEEK")
    public PatternDto findPatternDay() {
        return this.mapper.findPatternDay();
    }

    @SqlOperation(type=SqlOperation.SqlType.SELECT, table="PATN_JOB_LOG", param="patternType", param2="exeDay")
    public PatternJobDto findPatternJobLog(String patternType, String exeDay) {
        return this.mapper.findPatternJobLog(patternType, exeDay);
    }

    @SqlOperation(type=SqlOperation.SqlType.INSERT, table="PATN_JOB_LOG", param="patternType", param2="exeDay")
    public int insertPatternJobLog(String patternType, String exeDay) {
        return this.mapper.insertPatternJobLog(patternType, exeDay);
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="PATN_JOB_LOG", param="patternType", param2="exeDay")
    public int updatePatternJobLog(String patternType, String exeDay) {
        return this.mapper.updatePatternJobLog(patternType, exeDay);
    }

    @SqlOperation(type=SqlOperation.SqlType.TRUNCATE, table="PATN_WEEK_JOB")
    public int deletePatternWeekJob() {
        return this.mapper.deletePatternWeekJob();
    }

    @SqlOperation(type=SqlOperation.SqlType.TRUNCATE, table="PATN_15MIN_WEEK_JOB")
    public int deletePattern15MinWeekJob() {
        return this.mapper.deletePattern15MinWeekJob();
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="PATN_WEEK_JOB")
    public int updatePatternWeekJob(String patternTime) {
        return this.mapper.updatePatternWeekJob(patternTime);
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="PATN_15MIN_WEEK_JOB")
    public int updatePattern15minWeekJob(String patternTime) {
        return this.mapper.updatePattern15minWeekJob(patternTime);
    }

    public UticStatPatternRepository(UticStatPatternMapper mapper) {
        this.mapper = mapper;
    }
}

