/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.annotation.ProcessingElapsed;
import com.utic.center.common.service.AbstractProcessService;
import com.utic.center.utic.stat.server.dao.repository.UticStatParamRepository;
import com.utic.center.utic.stat.server.dto.CodeValueDto;
import com.utic.center.utic.stat.server.service.UticStatParamService;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UticStatParamService
implements AbstractProcessService {
    private static final Logger log = LoggerFactory.getLogger(UticStatParamService.class);
    private final UticStatParamRepository paramRepo;
    private final ConcurrentHashMap<String, CodeValueDto> mapData = new ConcurrentHashMap();

    @PostConstruct
    void init() {
        this.mapData.put(CodeValueKey.CODE_00.getKey(), new CodeValueDto("C01", "T01", "Y", Integer.valueOf(999), Integer.valueOf(999)));
        this.mapData.put(CodeValueKey.CODE_01.getKey(), new CodeValueDto("C01", "T02", "Y", Integer.valueOf(0), Integer.valueOf(0)));
        this.mapData.put(CodeValueKey.CODE_02.getKey(), new CodeValueDto("C01", "T03", "Y", Integer.valueOf(30), Integer.valueOf(30)));
        this.mapData.put(CodeValueKey.CODE_03.getKey(), new CodeValueDto("C01", "T04", "Y", Integer.valueOf(999), Integer.valueOf(999)));
        this.mapData.put(CodeValueKey.CODE_04.getKey(), new CodeValueDto("C01", "T05", "10", Integer.valueOf(999), Integer.valueOf(999)));
        this.mapData.put(CodeValueKey.CODE_05.getKey(), new CodeValueDto("C01", "T06", "2", Integer.valueOf(999), Integer.valueOf(999)));
        this.mapData.put(CodeValueKey.CODE_06.getKey(), new CodeValueDto("C02", "T01", "999", Integer.valueOf(5), Integer.valueOf(150)));
        this.mapData.put(CodeValueKey.CODE_07.getKey(), new CodeValueDto("C02", "T02", "999", Integer.valueOf(5), Integer.valueOf(130)));
        this.mapData.put(CodeValueKey.CODE_08.getKey(), new CodeValueDto("C02", "T03", "999", Integer.valueOf(5), Integer.valueOf(120)));
        this.mapData.put(CodeValueKey.CODE_09.getKey(), new CodeValueDto("C02", "T04", "999", Integer.valueOf(5), Integer.valueOf(90)));
        this.mapData.put(CodeValueKey.CODE_10.getKey(), new CodeValueDto("C02", "T05", "180", Integer.valueOf(999), Integer.valueOf(999)));
        this.mapData.put(CodeValueKey.CODE_11.getKey(), new CodeValueDto("C02", "T06", "999", Integer.valueOf(80), Integer.valueOf(20)));
        this.mapData.put(CodeValueKey.CODE_12.getKey(), new CodeValueDto("C02", "T07", "999", Integer.valueOf(80), Integer.valueOf(20)));
        this.mapData.put(CodeValueKey.CODE_13.getKey(), new CodeValueDto("C02", "T08", "999", Integer.valueOf(80), Integer.valueOf(20)));
        this.mapData.put(CodeValueKey.CODE_14.getKey(), new CodeValueDto("C02", "T09", "999", Integer.valueOf(80), Integer.valueOf(20)));
        this.mapData.put(CodeValueKey.CODE_15.getKey(), new CodeValueDto("C02", "T10", "999", Integer.valueOf(80), Integer.valueOf(20)));
        this.mapData.put(CodeValueKey.CODE_16.getKey(), new CodeValueDto("C02", "T11", "999", Integer.valueOf(80), Integer.valueOf(20)));
        this.mapData.put(CodeValueKey.CODE_17.getKey(), new CodeValueDto("C02", "T12", "Y", Integer.valueOf(999), Integer.valueOf(999)));
    }

    @ProcessingElapsed(type="PARAMETER", name="\uad50\ud1b5\uc815\ubcf4 \ud30c\ub77c\ubbf8\ud130 \ub85c\ub529", starting=false)
    public boolean processing() {
        this.loadCodeValue();
        return true;
    }

    public void loadCodeValue() {
        List result = this.paramRepo.findAllCodeValue();
        if (result != null) {
            for (CodeValueDto dto : result) {
                String key = dto.getMainCode() + dto.getSubCode();
                this.mapData.put(key, dto);
            }
        }
    }

    public CodeValueDto getCodeValue(CodeValueKey codeValueKey) {
        return (CodeValueDto)this.mapData.get(codeValueKey.getKey());
    }

    public UticStatParamRepository getParamRepo() {
        return this.paramRepo;
    }

    public ConcurrentHashMap<String, CodeValueDto> getMapData() {
        return this.mapData;
    }

    public UticStatParamService(UticStatParamRepository paramRepo) {
        this.paramRepo = paramRepo;
    }
}

