/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.config;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@ConfigurationProperties(prefix="application.scheduler")
public class SchedulingConfig
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SchedulingConfig.class);
    private int poolSize = 0;

    @PostConstruct
    private void init() {
        log.info("[{}] ------------", (Object)this.getClass().getSimpleName());
        if (this.poolSize == 0) {
            log.warn("[WAN] [{}] poolSize size set as default: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.poolSize);
            this.poolSize = 10;
        }
        log.info("[{}] poolCore: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.poolSize);
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(this.poolSize);
        threadPoolTaskScheduler.setThreadNamePrefix("scheduler-");
        threadPoolTaskScheduler.initialize();
        scheduledTaskRegistrar.setTaskScheduler((TaskScheduler)threadPoolTaskScheduler);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulingConfig)) {
            return false;
        }
        SchedulingConfig other = (SchedulingConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.getPoolSize() == other.getPoolSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPoolSize();
        return result;
    }

    public String toString() {
        return "SchedulingConfig(poolSize=" + this.getPoolSize() + ")";
    }
}

