/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.config;

import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
@ConfigurationProperties(prefix="application.thread-pool")
public class ThreadPoolInitializer
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolInitializer.class);
    private int schedule = 0;

    @PostConstruct
    private void init() {
        int MAX_CORE = Math.max(8, Runtime.getRuntime().availableProcessors());
        if (this.schedule <= 0) {
            this.schedule = MAX_CORE;
        }
        log.info("{}", (Object)this);
    }

    public ThreadPoolTaskExecutor getDefaultExecutor(int poolSize) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(poolSize);
        threadPoolTaskExecutor.setMaxPoolSize(poolSize * 2);
        threadPoolTaskExecutor.setQueueCapacity(2000);
        return threadPoolTaskExecutor;
    }

    @Bean(name={"scheduleExecutor"})
    public Executor getScheduleExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.schedule);
        threadPoolTaskExecutor.setThreadNamePrefix("schedule-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    public int getSchedule() {
        return this.schedule;
    }

    public void setSchedule(int schedule) {
        this.schedule = schedule;
    }
}

