/*
 * Decompiled with CFR 0.152.
 */
package com.utic.center.utic.stat.server.service;

import com.utic.center.common.annotation.ProcessingElapsed;
import com.utic.center.common.service.AbstractProcessService;
import com.utic.center.common.utils.LogUtils;
import com.utic.center.utic.stat.server.dao.repository.UticStat05MinStatRepository;
import com.utic.center.utic.stat.server.dto.CodeValueDto;
import com.utic.center.utic.stat.server.repository.ApplicationRepository;
import com.utic.center.utic.stat.server.service.UticStatParamService;
import com.utic.center.utic.stat.server.service.UticStatPatternService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UticStat05MinStatService
implements AbstractProcessService {
    private static final Logger log = LoggerFactory.getLogger(UticStat05MinStatService.class);
    private final UticStatParamService paramService;
    private final UticStat05MinStatRepository statRepo;
    private final UticStatPatternService patternService;

    @ProcessingElapsed(type="05MIN", name="\uc815\uc8fc\uae30 5\ubd84 \ud1b5\uacc4\uc0dd\uc131", starting=false)
    public boolean processing() {
        int level;
        String regDate = ApplicationRepository.regDate;
        log.info("[INF] {}: regDate[{}]", (Object)LogUtils.elapsedLog((String)"05\ubd84 \ud1b5\uacc4\uc2dc\uac01"), (Object)regDate);
        CodeValueDto codeValue0 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_00);
        CodeValueDto codeValue1 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_01);
        CodeValueDto codeValue2 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_02);
        CodeValueDto codeValue3 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_03);
        CodeValueDto codeValue4 = this.paramService.getCodeValue(UticStatParamService.CodeValueKey.CODE_04);
        this.statRepo.insertCenterLog(regDate);
        this.statRepo.insertStatTrafficLog(regDate);
        this.statRepo.insertFilterLog(regDate, codeValue0.getCodeValue(), codeValue1.getCodeValue(), codeValue2.getCodeValue(), codeValue3.getCodeValue(), codeValue4.getCodeValue());
        this.statRepo.insertLinkFilterLog(codeValue4.getCodeValue());
        this.statRepo.insertStat5MinCenter(regDate, codeValue4.getCodeValue());
        this.statRepo.insertStatFilterLog(regDate);
        for (level = 2; level <= 4; ++level) {
            this.statRepo.insertStat5MinCenterLevel(String.valueOf(level), regDate);
        }
        this.statRepo.updateStat5MinCenterTravelTime(regDate);
        this.patternService.patternUpdate(regDate, true);
        this.statRepo.insertStat5MinLoc(regDate, codeValue4.getCodeValue());
        for (level = 2; level <= 4; ++level) {
            this.statRepo.insertStat5MinLocLevel(String.valueOf(level), regDate);
        }
        this.statRepo.updateStat5MinLocTravelTime(regDate);
        return true;
    }

    public UticStatParamService getParamService() {
        return this.paramService;
    }

    public UticStat05MinStatRepository getStatRepo() {
        return this.statRepo;
    }

    public UticStatPatternService getPatternService() {
        return this.patternService;
    }

    public UticStat05MinStatService(UticStatParamService paramService, UticStat05MinStatRepository statRepo, UticStatPatternService patternService) {
        this.paramService = paramService;
        this.statRepo = statRepo;
        this.patternService = patternService;
    }
}

