/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.tcp.handler.MdcLoggingHandler;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.common.utils.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class TraceConfig {
    private static final Logger log = LoggerFactory.getLogger(TraceConfig.class);
    private final TsiNodeManager nodeManager;
    private Set<Long> currentDumpNodeIds = new HashSet();
    private Set<String> currentTcpDumpIps = new HashSet();
    private boolean queueReport = false;
    private boolean sessionReport = false;
    private boolean nodeLogging = false;

    @PostConstruct
    void init() {
        this.loadTraceInfo();
    }

    private Properties getProperties() {
        String traceFileName = System.getProperty("user.dir") + File.separator + "conf" + File.separator + "tsi-comm-server" + "-trace.cfg";
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(traceFileName);
            props.load(in);
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    private long getNodeId(String nodeId) {
        try {
            return Long.parseLong(nodeId.trim());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public void loadTraceInfo() {
        try {
            Properties props = this.getProperties();
            Set newDumpNodeIds = StringUtils.splitToStream((String)props.getProperty("DUMP", ""), (String)",").map(arg_0 -> this.getNodeId(arg_0)).filter(id -> id > 0L).collect(Collectors.toSet());
            HashSet nodesToDisableDump = new HashSet(this.currentDumpNodeIds);
            nodesToDisableDump.removeAll(newDumpNodeIds);
            nodesToDisableDump.forEach(nodeId -> this.updateDumpStatus(nodeId.longValue(), false));
            HashSet<Long> nodesToEnableDump = new HashSet<Long>(newDumpNodeIds);
            nodesToEnableDump.removeAll(this.currentDumpNodeIds);
            nodesToEnableDump.forEach(nodeId -> this.updateDumpStatus(nodeId.longValue(), true));
            this.currentDumpNodeIds = newDumpNodeIds;
            Set newTcpDumpIps = StringUtils.splitToStream((String)props.getProperty("TCP-DUMP", ""), (String)",").collect(Collectors.toSet());
            HashSet ipsToDisableTcpDump = new HashSet(this.currentTcpDumpIps);
            ipsToDisableTcpDump.removeAll(newTcpDumpIps);
            ipsToDisableTcpDump.forEach(ip -> this.updateTcpDumpStatus(ip, false));
            HashSet<String> ipsToEnableTcpDump = new HashSet<String>(newTcpDumpIps);
            ipsToEnableTcpDump.removeAll(this.currentTcpDumpIps);
            ipsToEnableTcpDump.forEach(ip -> this.updateTcpDumpStatus(ip, true));
            this.currentTcpDumpIps = newTcpDumpIps;
            this.sessionReport = props.getProperty("session-report", "false").trim().equalsIgnoreCase("true");
            this.queueReport = props.getProperty("queue-report", "false").trim().equalsIgnoreCase("true");
            this.nodeLogging = props.getProperty("node-logging", "false").trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            MDC.put((String)"filename", (String)"config");
            log.error("loadTraceInfo: Exception: {}", (Object)e.getMessage());
            MDC.clear();
        }
    }

    private void updateTcpDumpStatus(String ipAddr, boolean shouldTcpDump) {
        TsiNodeVo nodeVo = this.nodeManager.getIpAddr(ipAddr);
        if (nodeVo != null && nodeVo.isTcpDump() != shouldTcpDump) {
            MDC.put((String)"filename", (String)"config");
            log.info("TCP dump status changed for node {}: {} -> {}", new Object[]{nodeVo.getNodeId(), nodeVo.isTcpDump(), shouldTcpDump});
            MDC.clear();
            this.updateTcpDumpForChannel(nodeVo, shouldTcpDump);
        }
    }

    private void updateDumpStatus(long nodeId, boolean shouldDump) {
        TsiNodeVo nodeVo = this.nodeManager.get(nodeId);
        if (nodeVo != null && nodeVo.isDump() != shouldDump) {
            MDC.put((String)"filename", (String)"config");
            log.info("Dump status changed for node {}: {} -> {}", new Object[]{nodeId, nodeVo.isDump(), shouldDump});
            MDC.clear();
            nodeVo.setDump(shouldDump);
        }
    }

    private void updateTcpDumpForChannel(TsiNodeVo nodeVo, boolean addHandler) {
        Channel channel = nodeVo.getChannel();
        if (channel == null || !channel.isActive()) {
            return;
        }
        String handlerName = "dumpLogger";
        try {
            channel.eventLoop().execute(() -> {
                boolean hasHandler;
                ChannelPipeline pipeline = channel.pipeline();
                boolean bl = hasHandler = pipeline.get("dumpLogger") != null;
                if (addHandler && !hasHandler) {
                    MDC.put((String)"filename", (String)"config");
                    log.info("Adding TCP dump handler to channel for center: {}, {}", (Object)nodeVo.getNodeId(), (Object)nodeVo.getIpAddr());
                    MDC.clear();
                    pipeline.addFirst("dumpLogger", (ChannelHandler)new MdcLoggingHandler(LogLevel.INFO));
                } else if (!addHandler && hasHandler) {
                    MDC.put((String)"filename", (String)"config");
                    log.info("Removing TCP dump handler from channel for center: {}, {}", (Object)nodeVo.getNodeId(), (Object)nodeVo.getIpAddr());
                    MDC.clear();
                    pipeline.remove("dumpLogger");
                }
            });
        }
        catch (Exception e) {
            MDC.put((String)"filename", (String)"config");
            log.error("updateTcpDumpForChannel Exception: {}", (Object)e.getMessage());
            MDC.clear();
        }
    }

    public void loadTraceInfo2() {
        try {
            Properties props = this.getProperties();
            Set dumpNodeIds = StringUtils.splitToStream((String)props.getProperty("DUMP", ""), (String)",").map(arg_0 -> this.getNodeId(arg_0)).filter(id -> id > 0L).collect(Collectors.toSet());
            Set tcpDumpIps = StringUtils.splitToStream((String)props.getProperty("TCP-DUMP", ""), (String)",").collect(Collectors.toSet());
            for (TsiNodeVo nodeVo : this.nodeManager.getAllNodes()) {
                boolean shouldDump = dumpNodeIds.contains(nodeVo.getNodeId());
                if (nodeVo.isDump() != shouldDump) {
                    MDC.put((String)"filename", (String)"config");
                    log.info("Dump status changed for node {}: {} -> {}", new Object[]{nodeVo.getNodeId(), nodeVo.isDump(), shouldDump});
                    MDC.clear();
                    nodeVo.setDump(shouldDump);
                }
                boolean shouldTcpDump = tcpDumpIps.contains(nodeVo.getIpAddr());
                if (nodeVo.isTcpDump() == shouldTcpDump) continue;
                MDC.put((String)"filename", (String)"config");
                log.info("TCP dump status changed for node {}: {} -> {}", new Object[]{nodeVo.getNodeId(), nodeVo.isTcpDump(), shouldTcpDump});
                MDC.clear();
                nodeVo.setTcpDump(shouldTcpDump);
                this.updateTcpDumpForChannel(nodeVo, shouldTcpDump);
            }
            this.sessionReport = props.getProperty("session-report", "false").trim().equalsIgnoreCase("true");
            this.queueReport = props.getProperty("queue-report", "false").trim().equalsIgnoreCase("true");
            this.nodeLogging = props.getProperty("node-logging", "false").trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            MDC.put((String)"filename", (String)"config");
            log.error("loadTraceInfo: Exception: {}", (Object)e.getMessage());
            MDC.clear();
        }
    }

    public TsiNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Set<Long> getCurrentDumpNodeIds() {
        return this.currentDumpNodeIds;
    }

    public Set<String> getCurrentTcpDumpIps() {
        return this.currentTcpDumpIps;
    }

    public boolean isQueueReport() {
        return this.queueReport;
    }

    public boolean isSessionReport() {
        return this.sessionReport;
    }

    public boolean isNodeLogging() {
        return this.nodeLogging;
    }

    public void setCurrentDumpNodeIds(Set<Long> currentDumpNodeIds) {
        this.currentDumpNodeIds = currentDumpNodeIds;
    }

    public void setCurrentTcpDumpIps(Set<String> currentTcpDumpIps) {
        this.currentTcpDumpIps = currentTcpDumpIps;
    }

    public void setQueueReport(boolean queueReport) {
        this.queueReport = queueReport;
    }

    public void setSessionReport(boolean sessionReport) {
        this.sessionReport = sessionReport;
    }

    public void setNodeLogging(boolean nodeLogging) {
        this.nodeLogging = nodeLogging;
    }

    public String toString() {
        return "TraceConfig(nodeManager=" + this.getNodeManager() + ", currentDumpNodeIds=" + this.getCurrentDumpNodeIds() + ", currentTcpDumpIps=" + this.getCurrentTcpDumpIps() + ", queueReport=" + this.isQueueReport() + ", sessionReport=" + this.isSessionReport() + ", nodeLogging=" + this.isNodeLogging() + ")";
    }

    public TraceConfig(TsiNodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }
}

