/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.dto.mongodb;

import com.tsi.comm.server.dto.TsiCvimAbnormal;
import com.tsi.comm.server.dto.TsiCvimControl;
import com.tsi.comm.server.dto.TsiCvimStatus;
import com.tsi.comm.server.dto.mongodb.TcsNodeStatus;
import com.tsi.common.utils.StringUtils;
import java.util.List;

public class TcsNodeStatus {
    private final Long _id;
    private final Long nodeId;
    private final boolean isConnect;
    private final String collectTime;
    private final String tscDateTime;
    private final int cycleElapsedTime;
    private final TsiCvimControl tscControlInfo;
    private final TsiCvimAbnormal tscAbnormalInfo;
    private final int signalStatusInfoCount;
    private final List<TsiCvimStatus> signalStatusInfos;

    public TcsNodeStatus(Long _id, Long nodeId, boolean isConnect, String collectTime, String tscDateTime, int cycleElapsedTime, TsiCvimControl tscControlInfo, TsiCvimAbnormal tscAbnormalInfo, int signalStatusInfoCount, List<TsiCvimStatus> signalStatusInfos) {
        this._id = _id;
        this.nodeId = nodeId;
        this.isConnect = isConnect;
        this.collectTime = collectTime;
        this.tscDateTime = tscDateTime;
        this.cycleElapsedTime = cycleElapsedTime;
        this.tscControlInfo = tscControlInfo;
        this.tscAbnormalInfo = tscAbnormalInfo;
        this.signalStatusInfoCount = signalStatusInfoCount;
        this.signalStatusInfos = signalStatusInfos;
    }

    private String toValue(String connect) {
        return this.nodeId + "," + connect + "," + this.collectTime + "," + this.tscDateTime + "," + this.cycleElapsedTime + "," + this.signalStatusInfoCount;
    }

    public String toDataString() {
        String connect = StringUtils.getString((boolean)this.isConnect);
        if (this.isConnect) {
            String statusValue = "";
            for (TsiCvimStatus status : this.signalStatusInfos) {
                statusValue = statusValue + status.toDataString() + "|";
            }
            return this.toValue(connect) + "^" + this.tscControlInfo.toDataString() + "^" + this.tscAbnormalInfo.toDataString() + "^" + statusValue;
        }
        return this.nodeId + "," + connect;
    }

    public static TcsNodeStatusBuilder builder() {
        return new TcsNodeStatusBuilder();
    }

    public Long get_id() {
        return this._id;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public boolean isConnect() {
        return this.isConnect;
    }

    public String getCollectTime() {
        return this.collectTime;
    }

    public String getTscDateTime() {
        return this.tscDateTime;
    }

    public int getCycleElapsedTime() {
        return this.cycleElapsedTime;
    }

    public TsiCvimControl getTscControlInfo() {
        return this.tscControlInfo;
    }

    public TsiCvimAbnormal getTscAbnormalInfo() {
        return this.tscAbnormalInfo;
    }

    public int getSignalStatusInfoCount() {
        return this.signalStatusInfoCount;
    }

    public List<TsiCvimStatus> getSignalStatusInfos() {
        return this.signalStatusInfos;
    }

    public String toString() {
        return "TcsNodeStatus(_id=" + this.get_id() + ", nodeId=" + this.getNodeId() + ", isConnect=" + this.isConnect() + ", collectTime=" + this.getCollectTime() + ", tscDateTime=" + this.getTscDateTime() + ", cycleElapsedTime=" + this.getCycleElapsedTime() + ", tscControlInfo=" + this.getTscControlInfo() + ", tscAbnormalInfo=" + this.getTscAbnormalInfo() + ", signalStatusInfoCount=" + this.getSignalStatusInfoCount() + ", signalStatusInfos=" + this.getSignalStatusInfos() + ")";
    }
}

