/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.repository.TsiTpmsManager;
import com.tsi.comm.server.vo.mariadb.KafkaTransVo;
import com.tsi.common.utils.TimeUtils;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.support.Acknowledgment;

public class TsiKafkaConsumerWorker
implements MessageListener<String, Long> {
    private static final Logger log = LoggerFactory.getLogger(TsiKafkaConsumerWorker.class);
    private final TsiTpmsManager tpmsManager;
    private final TsiCvimDbmsProcess dbmsProcess;

    public void onMessage(ConsumerRecord<String, Long> consumerRecord) {
        Long sendNanoTime = (Long)consumerRecord.value();
        Long recvNanoTime = System.nanoTime();
        KafkaTransVo stat = new KafkaTransVo(3);
        stat.setHostName(this.tpmsManager.getKafkaTransVo().getHostName());
        stat.setStatus(1L);
        if (this.tpmsManager.getKafkaTransVo().getSendNanoTime() == sendNanoTime.longValue()) {
            stat.setSendTm(this.tpmsManager.getKafkaTransVo().getSendTm());
            stat.setRecvTm(TimeUnit.MICROSECONDS.convert(Math.abs(recvNanoTime - sendNanoTime), TimeUnit.NANOSECONDS));
        } else {
            stat.setRecvTm(TimeUnit.MICROSECONDS.convert(Math.abs(recvNanoTime - sendNanoTime), TimeUnit.NANOSECONDS));
            stat.setSendTm(stat.getRecvTm());
            log.info("recv ping success, sendNanoTime miss match: {}, {}", (Object)sendNanoTime, (Object)TimeUtils.elapsedTimeStr((long)(recvNanoTime - sendNanoTime)));
        }
        this.dbmsProcess.add((Object)stat, 0);
        log.info("recv ping success: {}, {}", (Object)sendNanoTime, (Object)TimeUtils.elapsedTimeStr((long)(recvNanoTime - sendNanoTime)));
    }

    public void onMessage(@NotNull ConsumerRecord<String, Long> consumerRecord, Acknowledgment acknowledgment) {
        try {
            Long sendNanoTime = (Long)consumerRecord.value();
            Long recvNanoTime = System.nanoTime();
            log.info("recv ping success, ack: {}, {}", (Object)sendNanoTime, (Object)TimeUtils.elapsedTimeStr((long)(recvNanoTime - sendNanoTime)));
        }
        catch (Exception e) {
            log.error("KafkaConsumerWorker.onMessage\uff1a{}", (Object)e.getMessage());
        }
    }

    public TsiKafkaConsumerWorker(TsiTpmsManager tpmsManager, TsiCvimDbmsProcess dbmsProcess) {
        this.tpmsManager = tpmsManager;
        this.dbmsProcess = dbmsProcess;
    }
}

