/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.dbms;

import com.tsi.comm.server.dao.maraidb.mapper.TsiCommServerMapper;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.vo.mariadb.AbstractDbmsVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.comm.server.vo.mariadb.CommStatusVo;
import com.tsi.comm.server.vo.mariadb.KafkaTransVo;
import com.tsi.comm.server.vo.mariadb.NodeIpAddrVo;
import com.tsi.comm.server.vo.mariadb.NodeStatusVo;
import com.tsi.comm.server.vo.mariadb.ProcessExitVo;
import com.tsi.common.spring.SpringUtils;
import com.tsi.common.utils.Elapsed;
import com.tsi.common.utils.TimeUtils;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiCvimDbmsWorker
extends AbstractTsiCvimWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimDbmsWorker.class);
    public static final ProcessExitVo SHUTDOWN_PACKET = new ProcessExitVo(0);
    private final LinkedBlockingQueue<Object> DATA_QUEUE;
    private final TsiCommServerMapper tsiCommServerMapper;

    public TsiCvimDbmsWorker(int idx, int qSize) {
        this.idx = idx;
        this.qSize = qSize;
        this.DATA_QUEUE = new LinkedBlockingQueue(qSize);
        this.tsiCommServerMapper = (TsiCommServerMapper)SpringUtils.getBean(TsiCommServerMapper.class);
    }

    @Override
    public void run() {
        log.info("DbmsWorker({}): {} Start. QSIZE: {}", new Object[]{this.idx, Thread.currentThread().getName(), this.qSize});
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Object object = this.DATA_QUEUE.take();
                    if (object == SHUTDOWN_PACKET) {
                        log.info("DbmsWorker({}): Shutdown signal received. Exiting...", (Object)this.idx);
                        break;
                    }
                    this.process(object);
                }
                catch (InterruptedException ie) {
                    log.warn("DbmsWorker({}): {} Interrupted. Exiting...", (Object)this.idx, (Object)Thread.currentThread().getName());
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    log.error("DbmsWorker({}): {} Exception: {}", new Object[]{this.idx, Thread.currentThread().getName(), e.getMessage()});
                }
            }
        }
        finally {
            log.info("DbmsWorker({}): {} Stopped.", (Object)this.idx, (Object)Thread.currentThread().getName());
        }
    }

    public boolean add(Object object) {
        boolean offer = false;
        try {
            offer = this.DATA_QUEUE.offer(object);
            if (!offer) {
                log.error("DbmsWorker({}): Queue.offer(Full): {}/{}/{}, {}, {}", new Object[]{this.idx, this.DATA_QUEUE.size(), this.qSize, this.DATA_QUEUE.remainingCapacity(), object, Thread.currentThread().getName()});
            }
        }
        catch (Exception e) {
            log.error("DbmsWorker({}): Queue.offer: Exception: {}, {}, {}", new Object[]{this.idx, object.toString(), Thread.currentThread().getName(), e.getMessage()});
        }
        return offer;
    }

    public void process(Object object) {
        Elapsed elapsed = new Elapsed();
        String job = "Unknown";
        int count = 0;
        if (object instanceof AbstractDbmsVo) {
            AbstractDbmsVo dbmsVo = (AbstractDbmsVo)object;
            try {
                if (dbmsVo.getDbmsType() == 2) {
                    job = "CommTpHs";
                    count = 1;
                    this.tsiCommServerMapper.insertCommTpsHs((CommStatusVo)dbmsVo);
                } else if (dbmsVo.getDbmsType() == 3) {
                    job = "KafkaTransHs";
                    count = 1;
                    this.tsiCommServerMapper.insertKafkaTransHs((KafkaTransVo)dbmsVo);
                } else if (dbmsVo.getDbmsType() == 1) {
                    job = "NodeStatus";
                    count = 1;
                    this.tsiCommServerMapper.updateNodeStatus((NodeStatusVo)object);
                } else if (dbmsVo.getDbmsType() == 4) {
                    job = "AlarmOccr";
                    count = 1;
                    this.tsiCommServerMapper.insertAlarmOccrHs((AlarmOccrVo)object);
                } else if (dbmsVo.getDbmsType() == 6) {
                    job = "NodeIpAddr";
                    count = 1;
                    this.tsiCommServerMapper.updateNodeIpAddr((NodeIpAddrVo)object);
                }
            }
            catch (Exception e) {
                log.error("DbmsWorker.process: {}, {}, Exception: {}", new Object[]{job, dbmsVo, e.getMessage()});
            }
            this.calcProcessTime(dbmsVo.getCreateTime());
        } else {
            log.error("DbmsWorker.process: Unknown Object Class: {}", (Object)object.getClass().getSimpleName());
        }
        if (elapsed.milliSeconds() > 500L) {
            log.warn("{}: {} EA. {} {}", new Object[]{job, count, TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds()), Thread.currentThread().getName()});
        }
    }

    public void report() {
        log.info("DbmsWorker({}), Queue Total/Size/Remain: {}/{}/{}, Average: {}, {}", new Object[]{this.idx, this.qSize, this.DATA_QUEUE.size(), this.DATA_QUEUE.remainingCapacity(), TimeUtils.elapsedTimeStr((long)this.avgTime), Thread.currentThread().getName()});
    }

    public LinkedBlockingQueue<Object> getDATA_QUEUE() {
        return this.DATA_QUEUE;
    }

    public TsiCommServerMapper getTsiCommServerMapper() {
        return this.tsiCommServerMapper;
    }
}

