/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.service;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.packet.TsiChannelSession;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.protocol.TsiCpuDisconnected;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.service.TsiQueueDistributorService;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.comm.server.vo.mariadb.NodeStatusVo;
import com.tsi.comm.server.xnet.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConnectionLifecycleService {
    private static final Logger log = LoggerFactory.getLogger(ConnectionLifecycleService.class);
    private final TsiCvimServerConfig config;
    private final TsiNodeManager nodeManager;
    private final TsiSessionManager sessionManager;
    private final TsiAlarmManager alarmManager;
    private final TsiCvimPacketProcess packetProcess;
    private final TsiCvimDbmsProcess dbmsProcess;
    private final TsiQueueDistributorService queueDistributorService;

    public void handleChannelActive(ChannelHandlerContext ctx) {
        int sessions = this.sessionManager.add();
        String remoteIpAddr = NettyUtils.getRemoteIpAddress((Channel)ctx.channel());
        log.info("--channelActive: {}, {} Sessions.", (Object)remoteIpAddr, (Object)sessions);
        TsiNodeVo ipNodeVo = this.nodeManager.getIpAddr(remoteIpAddr);
        if (ipNodeVo == null) {
            this.alarmManager.reportUnknownIp(remoteIpAddr);
        } else {
            TsiChannelSession.sessionActive((TsiNodeVo)ipNodeVo, (String)remoteIpAddr);
        }
    }

    public void handleChannelInactive(ChannelHandlerContext ctx) {
        String remoteIpAddr = NettyUtils.getRemoteIpAddress((Channel)ctx.channel());
        int sessions = this.sessionManager.remove();
        TsiNodeVo nodeVo = this.sessionManager.getNodeVo(ctx.channel());
        Integer pktQIdx = (Integer)ctx.channel().attr(TsiSessionManager.PKT_Q_IDX_KEY).get();
        Integer dbmsQIdx = (Integer)ctx.channel().attr(TsiSessionManager.DBMS_Q_IDX_KEY).get();
        Integer logQIdx = (Integer)ctx.channel().attr(TsiSessionManager.LOG_Q_IDX_KEY).get();
        if (pktQIdx != null && dbmsQIdx != null && logQIdx != null) {
            this.queueDistributorService.releaseQueue(pktQIdx.intValue(), dbmsQIdx.intValue(), logQIdx.intValue());
        }
        if (nodeVo != null) {
            if (nodeVo.isRegistered()) {
                NodeStatusVo status = new NodeStatusVo(1);
                status.setServerId(this.config.getServerId());
                status.setNodeId(nodeVo.getNodeId());
                status.setStatus(0);
                status.setIpAddr(remoteIpAddr);
                this.dbmsProcess.add((Object)status, nodeVo.getDbmsQIdx());
            }
            long remoteIpAddress = NettyUtils.getRemoteIpAddressToLong((Channel)ctx.channel());
            int remotePort = NettyUtils.getRemotePort((Channel)ctx.channel());
            TsiCpuDisconnected packet = new TsiCpuDisconnected(nodeVo.getNodeId(), remoteIpAddress, remotePort);
            packet.setBuf(null);
            packet.setObj((Object)nodeVo);
            if (pktQIdx != null) {
                this.packetProcess.add((Object)packet, pktQIdx.intValue());
            } else {
                this.packetProcess.add((Object)packet, nodeVo.getPktQIdx());
            }
            TsiChannelSession.sessionInactive((TsiNodeVo)nodeVo, (String)remoteIpAddr);
            this.sessionManager.removeChannel(ctx.channel());
            ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).set(null);
            if (nodeVo.disconnectChannel(ctx.channel())) {
                log.info("channelInactive: {}, {}, sessions: {}", new Object[]{nodeVo.getNodeId(), remoteIpAddr, sessions});
            } else {
                log.warn("channelInactive: {}, {}, sessions: {}, Duplicate Connected.", new Object[]{nodeVo.getNodeId(), remoteIpAddr, sessions});
            }
        } else {
            log.info("channelInactive: {}, sessions: {}, Unknown node.", (Object)remoteIpAddr, (Object)sessions);
        }
    }

    public void handleIdleStateEvent(ChannelHandlerContext ctx, IdleStateEvent evt) {
        if (evt.state() == IdleState.READER_IDLE) {
            TsiNodeVo nodeVo = this.sessionManager.getNodeVo(ctx.channel());
            String remoteIpAddr = NettyUtils.getRemoteIpAddress((Channel)ctx.channel());
            if (nodeVo == null) {
                log.warn("userEventTriggered: READER_IDLE: {}", (Object)remoteIpAddr);
                if (this.alarmManager.checkAlarm(TsiAlarmConfigVo.COMM_02)) {
                    AlarmOccrVo alarm = new AlarmOccrVo(4);
                    alarm.setAlarmCode(TsiAlarmConfigVo.COMM_02);
                    alarm.setAlarmTarget(remoteIpAddr);
                    alarm.setAlarmValue(remoteIpAddr);
                    this.dbmsProcess.add((Object)alarm, 0);
                }
            } else {
                log.warn("userEventTriggered: READER_IDLE: {}, {}", (Object)remoteIpAddr, (Object)nodeVo.getNodeId());
                if (this.alarmManager.checkAlarm(TsiAlarmConfigVo.COMM_02)) {
                    AlarmOccrVo alarm = new AlarmOccrVo(4);
                    alarm.setAlarmCode(TsiAlarmConfigVo.COMM_02);
                    alarm.setAlarmTarget(nodeVo.getKey());
                    alarm.setAlarmValue(remoteIpAddr);
                    this.dbmsProcess.add((Object)alarm, nodeVo.getDbmsQIdx());
                }
                TsiChannelSession.sessionTimeout((TsiNodeVo)nodeVo, (String)remoteIpAddr);
            }
            ctx.channel().close();
        } else if (evt.state() == IdleState.WRITER_IDLE) {
            log.error("userEventTriggered: WRITER_IDLE: {}", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
        } else if (evt.state() == IdleState.ALL_IDLE) {
            log.error("userEventTriggered: ALL_IDLE: {}", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
        }
    }

    public void handleExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        TsiNodeVo nodeVo = this.sessionManager.getNodeVo(ctx.channel());
        if (nodeVo != null) {
            log.error("exceptionCaught: {}, {}", (Object)nodeVo.getNodeId(), (Object)ctx.channel());
        }
        log.error("exceptionCaught: {}", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
    }

    public ConnectionLifecycleService(TsiCvimServerConfig config, TsiNodeManager nodeManager, TsiSessionManager sessionManager, TsiAlarmManager alarmManager, TsiCvimPacketProcess packetProcess, TsiCvimDbmsProcess dbmsProcess, TsiQueueDistributorService queueDistributorService) {
        this.config = config;
        this.nodeManager = nodeManager;
        this.sessionManager = sessionManager;
        this.alarmManager = alarmManager;
        this.packetProcess = packetProcess;
        this.dbmsProcess = dbmsProcess;
        this.queueDistributorService = queueDistributorService;
    }
}

