/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.xnet;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;

public abstract class NettyStats {
    protected Channel channel;
    protected long recordReceived;
    protected long recordSent;
    protected long bytesReceived;
    protected long bytesSent;
    protected long minLatency;
    protected long maxLatency;
    protected long count;
    protected long totalLatency;

    public abstract InetSocketAddress getRemoteSocketAddress();

    public NettyStats() {
        this.reset();
    }

    public synchronized void setChannel(Channel chn) {
        this.channel = chn;
    }

    public synchronized Channel getChannel() {
        return this.channel;
    }

    public synchronized void reset() {
        this.recordReceived = 0L;
        this.recordSent = 0L;
        this.bytesReceived = 0L;
        this.bytesSent = 0L;
        this.minLatency = Long.MAX_VALUE;
        this.maxLatency = 0L;
        this.count = 0L;
        this.totalLatency = 0L;
    }

    protected synchronized void updateStats(long start, long end, long receivedBytes, long sentBytes) {
        long elapsed = end - start;
        if (elapsed < this.minLatency) {
            this.minLatency = elapsed;
        }
        if (elapsed > this.maxLatency) {
            this.maxLatency = elapsed;
        }
        if (receivedBytes > 0L) {
            ++this.recordReceived;
            this.bytesReceived += receivedBytes;
        }
        if (sentBytes > 0L) {
            ++this.recordSent;
            this.bytesSent += sentBytes;
        }
        ++this.count;
        this.totalLatency += elapsed;
    }

    public synchronized long getRecordReceived() {
        return this.recordReceived;
    }

    public synchronized long getRecordSent() {
        return this.recordSent;
    }

    public synchronized long getBytesReceived() {
        return this.bytesReceived;
    }

    public synchronized long getBytesSent() {
        return this.bytesSent;
    }

    public synchronized long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    public synchronized long getMaxLatency() {
        return this.maxLatency;
    }

    public synchronized long getAvgLatency() {
        return this.count == 0L ? 0L : this.totalLatency / this.count;
    }

    public synchronized long getTotalLatency() {
        return this.totalLatency;
    }

    public synchronized long getCount() {
        return this.count;
    }
}

