/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConfigurationProperties(prefix="application.thread-pool")
public class TsiThreadPoolConfig
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(TsiThreadPoolConfig.class);
    private int poolCore = 0;
    private int MAX_CORE = Runtime.getRuntime().availableProcessors();

    @PostConstruct
    private void init() {
        log.info("[{}] -------------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]   availableProcessors: {}", (Object)this.getClass().getSimpleName(), (Object)this.MAX_CORE);
        if (this.MAX_CORE < 8) {
            this.MAX_CORE = 16;
        }
        log.info("[{}]              MAX_CORE: {}", (Object)this.getClass().getSimpleName(), (Object)this.MAX_CORE);
        log.info("[{}] threadPoolCore before: {}", (Object)this.getClass().getSimpleName(), (Object)this.poolCore);
        if (this.poolCore < this.MAX_CORE) {
            this.poolCore = this.MAX_CORE;
        }
        log.info("[{}] threadPoolCore .after: {}", (Object)this.getClass().getSimpleName(), (Object)this.poolCore);
        log.info("[{}]          CorePoolSize: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.poolCore);
        log.info("[{}]           MaxPoolSize: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.getMaxPoolSize());
        log.info("[{}]         QueueCapacity: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.getQueueCapacity());
    }

    public int getMaxPoolSize() {
        return this.poolCore * 2;
    }

    public int getQueueCapacity() {
        return this.poolCore * 4;
    }

    public ThreadPoolTaskExecutor getDefaultExecutor(int poolSize) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(poolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.getMaxPoolSize());
        threadPoolTaskExecutor.setQueueCapacity(this.getQueueCapacity());
        return threadPoolTaskExecutor;
    }

    @Bean(name={"queueJobExecutor"})
    public Executor getQueueJobExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.poolCore);
        threadPoolTaskExecutor.setThreadNamePrefix("queue-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"dbmsJobExecutor"})
    public Executor getDbmsJobExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.poolCore);
        threadPoolTaskExecutor.setThreadNamePrefix("dbms-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.poolCore * 2);
        threadPoolTaskExecutor.setThreadNamePrefix("tsi-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsiThreadPoolConfig)) {
            return false;
        }
        TsiThreadPoolConfig other = (TsiThreadPoolConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPoolCore() != other.getPoolCore()) {
            return false;
        }
        return this.getMAX_CORE() == other.getMAX_CORE();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsiThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPoolCore();
        result = result * 59 + this.getMAX_CORE();
        return result;
    }

    public int getPoolCore() {
        return this.poolCore;
    }

    public int getMAX_CORE() {
        return this.MAX_CORE;
    }

    public void setPoolCore(int poolCore) {
        this.poolCore = poolCore;
    }

    public void setMAX_CORE(int MAX_CORE) {
        this.MAX_CORE = MAX_CORE;
    }

    public String toString() {
        return "TsiThreadPoolConfig(poolCore=" + this.getPoolCore() + ", MAX_CORE=" + this.getMAX_CORE() + ")";
    }
}

