/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.comm.server.mybatis.vo.KafkaTransVo;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.repository.TsiTpmsManager;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.support.Acknowledgment;

public class TsiKafkaConsumerWorker
implements MessageListener<String, Long> {
    private static final Logger log = LoggerFactory.getLogger(TsiKafkaConsumerWorker.class);
    private TsiCvimDbmsProcess tsiCvimDbmsService = (TsiCvimDbmsProcess)AppUtils.getBean(TsiCvimDbmsProcess.class);

    public void onMessage(ConsumerRecord<String, Long> record) {
        Long sendNanoTime = (Long)record.value();
        Long recvNanoTime = System.nanoTime();
        KafkaTransVo stat = new KafkaTransVo(3);
        stat.setHostName(TsiTpmsManager.getInstance().getKafkaTransVo().getHostName());
        stat.setStatus(1L);
        if (TsiTpmsManager.getInstance().getKafkaTransVo().getSendNanoTime() == sendNanoTime.longValue()) {
            if (TsiTpmsManager.getInstance().getKafkaTransVo().getSendTm() == 0L) {
                try {
                    log.info("Oops... Receive getting faster.");
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            stat.setSendTm(TsiTpmsManager.getInstance().getKafkaTransVo().getSendTm());
            stat.setRecvTm(TimeUnit.MICROSECONDS.convert(recvNanoTime - sendNanoTime, TimeUnit.NANOSECONDS));
        } else {
            stat.setRecvTm(TimeUnit.MICROSECONDS.convert(recvNanoTime - sendNanoTime, TimeUnit.NANOSECONDS));
            stat.setSendTm(stat.getRecvTm());
            log.info("recv ping success, sendNanoTime miss match: {}, {}", (Object)sendNanoTime, (Object)TimeUtils.elapsedTimeStr((long)(recvNanoTime - sendNanoTime)));
        }
        this.tsiCvimDbmsService.add((Object)stat, (int)Thread.currentThread().getId());
        log.info("recv ping success: {}, {}", (Object)sendNanoTime, (Object)TimeUtils.elapsedTimeStr((long)(recvNanoTime - sendNanoTime)));
    }

    public void onMessage(ConsumerRecord<String, Long> record, Acknowledgment acknowledgment) {
        try {
            Long sendNanoTime = (Long)record.value();
            Long recvNanoTime = System.nanoTime();
            log.info("recv ping success, ack: {}, {}", (Object)sendNanoTime, (Object)TimeUtils.elapsedTimeStr((long)(recvNanoTime - sendNanoTime)));
        }
        catch (Exception e) {
            log.error("onMessage\uff1a" + e.getMessage());
        }
    }
}

