/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.logging;

import com.tsi.app.common.app.AppUtils;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.AbstractTsiCvimProcess;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.logging.TsiCvimLoggingWorker;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.repository.TsiNodeManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimLoggingProcess
extends AbstractTsiCvimProcess {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimLoggingProcess.class);
    private List<TsiCvimLoggingWorker> workerList = new ArrayList();

    @PostConstruct
    void init() {
        int qSize;
        int nodes;
        ThreadGroup workerGroup = new ThreadGroup("loggingProcess");
        TsiCvimServerConfig tsiCvimServerConfig = (TsiCvimServerConfig)AppUtils.getBean(TsiCvimServerConfig.class);
        this.workers = tsiCvimServerConfig.getLoggingWorkers();
        if (this.workers <= 0) {
            this.workers = 1;
        }
        if ((nodes = TsiNodeManager.getInstance().size()) > (qSize = tsiCvimServerConfig.getQueueSize())) {
            qSize = nodes;
        }
        qSize *= 6;
        qSize /= this.workers;
        for (int ii = 0; ii < this.workers; ++ii) {
            TsiCvimLoggingWorker loggingWorker = new TsiCvimLoggingWorker(ii, qSize);
            this.workerList.add(loggingWorker);
            Thread worker = new Thread(workerGroup, (Runnable)loggingWorker);
            worker.setName(String.format("logWorker-%02d.%02d", this.workers, ii + 1));
            worker.setDaemon(true);
            this.threadList.add(worker);
        }
        for (Thread worker : this.threadList) {
            worker.start();
        }
    }

    public boolean add(Object object, int idx) {
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            offer = ((TsiCvimLoggingWorker)this.workerList.get(idx %= this.workers)).add((Object)packet);
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("QUEUE_DATA.add: Exception: {}, {}", (Object)packet.getNodeId(), (Object)e.getMessage());
            MDC.clear();
        }
        return offer;
    }

    public void stop() {
    }

    public void report() {
        for (AbstractTsiCvimWorker worker : this.workerList) {
            worker.report();
        }
    }

    public List<TsiCvimLoggingWorker> getWorkerList() {
        return this.workerList;
    }
}

