/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.protocol;

import com.tsi.app.common.cpu.dto.TsiCvimAbnormal;
import com.tsi.app.common.cpu.dto.TsiCvimControl;
import com.tsi.app.common.cpu.dto.TsiCvimStatus;
import com.tsi.app.common.cpu.enums.eLightsStatus;
import com.tsi.app.common.cpu.enums.eLightsType;
import com.tsi.app.common.cpu.enums.eOpCode;
import com.tsi.app.common.cpu.enums.eTimeReliability;
import com.tsi.app.common.utils.ByteUtils;
import com.tsi.app.common.utils.CRC16Utils;
import com.tsi.app.common.utils.HexString;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.mongo.dto.TcsNodeStatus;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.protocol.TsiCpuAddPacket;
import com.tsi.comm.server.repository.TsiNodeAddManager;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiCpuPacket
extends AbstractTsiPacket {
    private static final Logger log = LoggerFactory.getLogger(TsiCpuPacket.class);
    public static final byte STX1 = 126;
    public static final byte STX2 = 126;
    public static final int SIZE_HEAD = 10;
    public static final int SIZE_STX1 = 1;
    public static final int SIZE_STX2 = 1;
    public static final int SIZE_LENGTH = 2;
    public static final int SIZE_OPCODE = 1;
    public static final int SIZE_VERSION = 1;
    public static final int SIZE_NODE_ID = 4;
    public static final int SIZE_STATUS_HDR = 8;
    public static final int SIZE_STATUS_DATA = 5;
    public static final int SIZE_CHECKSUM = 2;
    public static final int SIZE_PACKET_DATA = 18;
    public static final int INDEX_STX1 = 0;
    public static final int INDEX_STX2 = 1;
    public static final int INDEX_LENGTH = 2;
    public static final int INDEX_OPCODE = 4;
    public static final int INDEX_VERSION = 5;
    public static final int INDEX_NODE_ID = 6;
    public static final int INDEX_STATUS_HDR = 10;
    public static final int INDEX_STATUS_DATA = 18;
    public static final int INDEX_STATUS_DIR_ADD = 0;
    public static final int INDEX_STATUS_DIRECTION = 4;
    public static final int SIZE_NODE_DUMMY = 8;
    public static final int SIZE_NODE_HEAD = 12;
    public static final int POS_NODE_HEAD_NODEID = 0;
    public static final int POS_NODE_HEAD_COUNT = 7;
    public static final int SIZE_IPC_SIZE = 27;
    public static final int SIZE_TIMESPEC = 16;
    public static final int POS_IPC_TIMESPEC = 0;
    public static final int POS_IPC_IPADDR = 16;
    public static final int POS_IPC_PORT = 20;
    public static final int POS_IPC_CONNECT = 22;
    public static final int POS_IPC_NODEID = 23;
    public static final int POS_IPC_PACKET = 27;
    public static final byte CONNECT = 1;
    public static final byte DISCONNECT = 0;
    private Object obj;
    private int length;
    private byte dataVer;
    private int count;
    private int checkSum;
    protected byte[] cvimData;
    protected byte[] nodeData;
    protected List<TsiCpuAddPacket> addNodes;

    public TsiCpuPacket(long nodeId, long msec, long nsec, Channel channel) {
        super(nodeId, msec, nsec, NettyUtils.getRemoteIpAddressToLong((Channel)channel), NettyUtils.getRemotePort((Channel)channel));
        this.setOpCode(eOpCode.TSI_CPU_SIGNAL_NOTIFY.getValue());
    }

    public TsiCpuPacket(long nodeId, long msec, long nsec, long remoteIpAddressToLong, int remotePort) {
        super(nodeId, msec, nsec, remoteIpAddressToLong, remotePort);
    }

    public TsiCpuPacket(long nodeId, byte[] value) {
        super(nodeId, TimeUtils.currentTimeSeconds(), System.nanoTime(), 0L, 0);
        this.buf = value;
        int nodeLength = this.buf.length - 27;
        this.cvimData = new byte[27];
        System.arraycopy(this.buf, 0, this.cvimData, 0, 27);
        if (nodeLength > 0) {
            this.nodeData = new byte[nodeLength];
            System.arraycopy(this.buf, 27, this.nodeData, 0, nodeLength);
        }
    }

    protected byte getStx1() {
        if (this.buf != null) {
            return this.buf[0];
        }
        return 0;
    }

    protected byte getStx2() {
        if (this.buf != null) {
            return this.buf[1];
        }
        return 0;
    }

    public byte[] getCvimData() {
        return this.cvimData;
    }

    public byte[] getTestData() {
        return this.buf;
    }

    public byte[] getNodeData() {
        return this.nodeData;
    }

    protected void makeCvimPacket() {
        int length = this.buf == null ? 0 : this.buf.length;
        this.cvimData = new byte[27 + length];
        System.arraycopy(this.timespec.bytes(), 0, this.cvimData, 0, 16);
        ByteUtils.setUnsignedInt((byte[])this.cvimData, (int)16, (long)this.getRemoteIp());
        ByteUtils.setUnsignedShort((byte[])this.cvimData, (int)20, (int)this.getRemotePort());
        this.cvimData[22] = this.opCode == (byte)eOpCode.TSI_CPU_SIGNAL_NOTIFY.getValue() ? (byte)1 : 0;
        ByteUtils.setUnsignedInt((byte[])this.cvimData, (int)23, (long)this.nodeId);
        if (length > 0) {
            System.arraycopy(this.buf, 0, this.cvimData, 27, length);
        }
    }

    protected void makeAddNodeCvimPaket(TsiCpuPacket cpuPacket, byte[] packet) {
        int length = packet == null ? 0 : packet.length;
        int headSize = 33;
        cpuPacket.cvimData = new byte[33 + length + 2];
        System.arraycopy(this.timespec.bytes(), 0, cpuPacket.cvimData, 0, 16);
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)16, (long)this.getRemoteIp());
        ByteUtils.setUnsignedShort((byte[])cpuPacket.cvimData, (int)20, (int)this.getRemotePort());
        cpuPacket.cvimData[22] = this.opCode == (byte)eOpCode.TSI_CPU_SIGNAL_NOTIFY.getValue() ? (byte)1 : 0;
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)23, (long)cpuPacket.nodeId);
        cpuPacket.cvimData[27] = this.getStx1();
        cpuPacket.cvimData[28] = this.getStx2();
        ByteUtils.setUnsignedShort((byte[])cpuPacket.cvimData, (int)29, (int)(length + 2));
        cpuPacket.cvimData[31] = (byte)this.getOpCode();
        cpuPacket.cvimData[32] = this.getDataVer();
        if (length > 0) {
            System.arraycopy(packet, 0, cpuPacket.cvimData, 33, length);
        }
    }

    protected boolean checkPacket() {
        if (this.buf[0] != 126 || this.buf[1] != 126) {
            log.info("Node: {}, STX Error: {}, {}", new Object[]{this.nodeId, this.buf[0], this.buf[1]});
            return false;
        }
        if (this.length != 18 + 5 * this.count) {
            log.info("Node: {}, Length Error: {}, status count: {}, {}", new Object[]{this.nodeId, this.length, this.count, 18 + 5 * this.count});
            return false;
        }
        this.checkSum = ByteUtils.getUnsignedShort((byte[])this.buf, (int)(this.buf.length - 2));
        int calcCheckSum = CRC16Utils.CRC16_ccitt_cvim((byte[])this.buf, (int)2, (int)(this.length - 2));
        if (this.checkSum != calcCheckSum) {
            log.error("Node: {}, Check Sum Error: recv: {}, calc: {}", new Object[]{this.nodeId, this.checkSum, calcCheckSum});
            log.error("{}", (Object)HexString.fromBytes((byte[])this.buf));
            return false;
        }
        return true;
    }

    public boolean parsing(TsiNodeVo obj) {
        this.opCode = this.buf[4];
        this.dataVer = this.buf[5];
        this.length = ByteUtils.getUnsignedShort((byte[])this.buf, (int)2);
        this.count = this.buf[13] & 0x7F;
        this.makeCvimPacket();
        if (!this.checkPacket()) {
            return false;
        }
        TsiNodeAddVo tsiNodeAddVo = TsiNodeAddManager.getInstance().get(this.nodeId);
        if (tsiNodeAddVo == null) {
            int length = this.buf.length - 8;
            this.nodeData = new byte[length];
            System.arraycopy(this.buf, 6, this.nodeData, 0, length);
            return true;
        }
        byte[] head = new byte[12];
        ArrayList<byte[]> nodeStatus = new ArrayList<byte[]>();
        HashMap addStatus = new HashMap();
        System.arraycopy(this.buf, 6, head, 0, 12);
        int ii = 18;
        for (int loop = 0; loop < this.count; ++loop) {
            byte[] status = new byte[5];
            System.arraycopy(this.buf, ii, status, 0, 5);
            int dirAdd = status[0] & 0xF;
            if (dirAdd == 0) {
                nodeStatus.add(status);
            } else {
                byte directionCode = status[4];
                status[0] = (byte)(status[0] & 0xF0);
                TsiNodeAddDetailVo detailVo = (TsiNodeAddDetailVo)tsiNodeAddVo.getAddNodeMap().get(directionCode * 1000 + dirAdd);
                if (detailVo != null) {
                    for (int dirIdx = 0; dirIdx < 2; ++dirIdx) {
                        if (detailVo.getAddDirCode()[dirIdx] == 0) continue;
                        ArrayList<byte[]> list = (ArrayList<byte[]>)addStatus.get(detailVo.getNodeId());
                        if (list == null) {
                            list = new ArrayList<byte[]>();
                            addStatus.put(detailVo.getNodeId(), list);
                        }
                        if (dirIdx == 0) {
                            status[4] = detailVo.getAddDirCode()[dirIdx];
                            list.add(status);
                            continue;
                        }
                        byte[] status2 = new byte[5];
                        System.arraycopy(status, 0, status2, 0, 5);
                        status2[4] = detailVo.getAddDirCode()[dirIdx];
                        list.add(status2);
                    }
                }
            }
            ii += 5;
        }
        int splitFlag = 1;
        int statusCount = nodeStatus.size();
        this.nodeData = new byte[12 + statusCount * 5];
        System.arraycopy(head, 0, this.nodeData, 0, 12);
        this.nodeData[7] = (byte)(statusCount | splitFlag << 7);
        for (int ii2 = 0; ii2 < statusCount; ++ii2) {
            System.arraycopy(nodeStatus.get(ii2), 0, this.nodeData, 12 + ii2 * 5, 5);
        }
        this.makeAddNodeCvimPaket(this, this.nodeData);
        if (addStatus.size() == 0) {
            return true;
        }
        this.addNodes = new ArrayList();
        for (Map.Entry entry : addStatus.entrySet()) {
            statusCount = ((List)entry.getValue()).size();
            TsiCpuAddPacket addPacket = new TsiCpuAddPacket(((Long)entry.getKey()).longValue(), this.timespec, this.remoteIp, this.remotePort);
            addPacket.setObj((Object)TsiNodeAddManager.getInstance().get(((Long)entry.getKey()).longValue()));
            addPacket.setNodeData(new byte[12 + statusCount * 5]);
            System.arraycopy(head, 0, addPacket.getNodeData(), 0, 12);
            ByteUtils.setUnsignedInt((byte[])addPacket.getNodeData(), (int)0, (long)((Long)entry.getKey()));
            addPacket.getNodeData()[7] = (byte)(statusCount | splitFlag << 7);
            for (int ii3 = 0; ii3 < statusCount; ++ii3) {
                System.arraycopy(((List)entry.getValue()).get(ii3), 0, addPacket.getNodeData(), 12 + ii3 * 5, 5);
            }
            this.makeAddNodeCvimPaket((TsiCpuPacket)addPacket, addPacket.getNodeData());
            this.addNodes.add(addPacket);
        }
        return true;
    }

    public TcsNodeStatus getNodeStatus() {
        int nodeLength = this.buf.length - 27;
        byte[] msec = new byte[8];
        byte[] nsec = new byte[8];
        System.arraycopy(this.cvimData, 0, msec, 0, 8);
        System.arraycopy(this.cvimData, 8, nsec, 0, 8);
        ByteBuffer byteMSec = ByteBuffer.wrap(msec);
        ByteBuffer byteNSec = ByteBuffer.wrap(nsec);
        byteMSec.order(ByteOrder.LITTLE_ENDIAN);
        byteNSec.order(ByteOrder.LITTLE_ENDIAN);
        long milliSeconds = byteMSec.getLong();
        long nanoSeconds = byteNSec.getLong();
        this.remoteIp = ByteUtils.getUnsignedInt((byte[])this.cvimData, (int)16);
        this.remotePort = ByteUtils.getUnsignedShort((byte[])this.cvimData, (int)20);
        this.getTimespec().tv_nsec(nanoSeconds);
        Date date = new Date(milliSeconds * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        String collectTime = sdf.format(date);
        if (this.cvimData[22] == 0) {
            return TcsNodeStatus.builder()._id(Long.valueOf(this.nodeId)).nodeId(Long.valueOf(this.nodeId)).isConnect(false).collectTime(collectTime).build();
        }
        if (nodeLength < 18) {
            return null;
        }
        TsiCvimControl tscControlInfo = new TsiCvimControl();
        TsiCvimAbnormal tscAbnormalInfo = new TsiCvimAbnormal();
        ArrayList<TsiCvimStatus> signalStatusInfos = new ArrayList<TsiCvimStatus>();
        byte control = this.cvimData[37];
        tscControlInfo.inManualControl = (control & 1) == 1;
        tscControlInfo.inFlashingControl = (control >> 1 & 1) == 1;
        tscControlInfo.inLightsOutControl = (control >> 2 & 1) == 1;
        tscControlInfo.inActuationControl = (control >> 3 & 1) == 1;
        tscControlInfo.inTransitionControl = (control >> 4 & 1) == 1;
        byte abnormal = this.cvimData[38];
        tscAbnormalInfo.inSignalConflict = (abnormal & 1) == 1;
        tscAbnormalInfo.inCenterComm = (abnormal >> 1 & 1) == 1;
        tscAbnormalInfo.inScuComm = (abnormal >> 2 & 1) == 1;
        int cycleElapsedTime = this.cvimData[39] & 0xFF;
        byte stts = this.cvimData[40];
        int signalStatusInfoCount = stts & 0x7F;
        long localTime = ByteUtils.getUnsignedInt((byte[])this.cvimData, (int)41);
        int ii = 45;
        for (int idx = 0; idx < signalStatusInfoCount; ++idx) {
            TsiCvimStatus status = new TsiCvimStatus();
            int lightsType = this.cvimData[ii] >> 4 & 0xF;
            int lightsStatus = this.cvimData[ii + 1] & 7;
            int reliability = this.cvimData[ii + 1] >> 7 & 1;
            boolean readyPedestrian = (this.cvimData[ii + 1] >> 6 & 1) == 1;
            boolean unProtected = (this.cvimData[ii + 1] >> 3 & 1) == 1;
            int totalSeconds = this.cvimData[ii + 2] & 0xFF;
            int remainSeconds = this.cvimData[ii + 3] & 0xFF;
            int directionCode = this.cvimData[ii + 4] & 0xFF;
            status.setLightsType(eLightsType.getByValue((int)lightsType));
            status.setLightsStatus(eLightsStatus.getByValue((int)lightsStatus));
            status.setTimeReliability(eTimeReliability.getByValue((int)reliability));
            status.setReadyPedestrianSignal(readyPedestrian);
            status.setUnProtectedSignal(unProtected);
            status.setTotalSeconds(totalSeconds);
            status.setRemainingSeconds(remainSeconds);
            status.setDirectionCode(directionCode);
            signalStatusInfos.add(status);
            ii += 5;
        }
        date = new Date(localTime * 1000L);
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        String tscDateTime = sdf.format(date);
        return TcsNodeStatus.builder()._id(Long.valueOf(this.nodeId)).nodeId(Long.valueOf(this.nodeId)).isConnect(true).collectTime(collectTime).tscDateTime(tscDateTime).cycleElapsedTime(cycleElapsedTime).tscControlInfo(tscControlInfo).tscAbnormalInfo(tscAbnormalInfo).signalStatusInfoCount(signalStatusInfoCount).signalStatusInfos(signalStatusInfos).build();
    }

    public Object getObj() {
        return this.obj;
    }

    public int getLength() {
        return this.length;
    }

    public byte getDataVer() {
        return this.dataVer;
    }

    public int getCount() {
        return this.count;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public List<TsiCpuAddPacket> getAddNodes() {
        return this.addNodes;
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDataVer(byte dataVer) {
        this.dataVer = dataVer;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public void setCvimData(byte[] cvimData) {
        this.cvimData = cvimData;
    }

    public void setNodeData(byte[] nodeData) {
        this.nodeData = nodeData;
    }

    public void setAddNodes(List<TsiCpuAddPacket> addNodes) {
        this.addNodes = addNodes;
    }
}

