/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.dao.maraidb.repository;

import com.tsi.comm.server.dao.maraidb.mapper.TsiCommServerMapper;
import com.tsi.comm.server.vo.mariadb.AlarmConfigVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.comm.server.vo.mariadb.CommStatusVo;
import com.tsi.comm.server.vo.mariadb.KafkaTransVo;
import com.tsi.comm.server.vo.mariadb.NodeAddVo;
import com.tsi.comm.server.vo.mariadb.NodeIpAddrVo;
import com.tsi.comm.server.vo.mariadb.NodeStatusVo;
import com.tsi.comm.server.vo.mariadb.NodeVo;
import com.tsi.comm.server.vo.mariadb.ProcessStateVo;
import com.tsi.common.annotation.SqlOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TsiCommServerRepository {
    private static final Logger log = LoggerFactory.getLogger(TsiCommServerRepository.class);
    private final TsiCommServerMapper mapper;

    @SqlOperation(type=SqlOperation.SqlType.SELECT, table="tb_tsc_alarm_config")
    public List<AlarmConfigVo> getAlarmConfig() {
        return this.mapper.getAlarmConfig();
    }

    @SqlOperation(type=SqlOperation.SqlType.INSERT, table="tb_tsc_alarm_hs")
    public int insertAlarmOccrHs(AlarmOccrVo obj) {
        return this.mapper.insertAlarmOccrHs(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.SELECT, table="tb_tsc_node")
    public List<NodeVo> getNodeInfoList() {
        return this.mapper.getNodeInfoList();
    }

    @SqlOperation(type=SqlOperation.SqlType.SELECT, table="tb_tsc_node_add")
    public List<NodeAddVo> getNodeAddInfoList() {
        return this.mapper.getNodeAddInfoList();
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="tb_tsc_node", param="ipaddr")
    public int updateNodeIpAddr(NodeIpAddrVo obj) {
        return this.mapper.updateNodeIpAddr(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.INSERT, table="tb_tsc_node_status", param="init")
    public int insertNodeStatusInitialize() {
        return this.mapper.insertNodeStatusInitialize();
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="tb_tsc_node_status", param="term")
    public int updateNodeStatusTerm(Integer serverId) {
        return this.mapper.updateNodeStatusTerm(serverId);
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="tb_tsc_node_status")
    public int updateNodeStatus(NodeStatusVo obj) {
        return this.mapper.updateNodeStatus(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.INSERT, table="tb_tsc_kafka_trans_hs")
    public int insertKafkaTransHs(KafkaTransVo obj) {
        return this.mapper.insertKafkaTransHs(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.INSERT, table="tb_tsc_comm_tps_hs")
    public int insertCommTpsHs(CommStatusVo obj) {
        return this.mapper.insertCommTpsHs(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="tb_tsc_process")
    public int updateProcessStatusStart(ProcessStateVo obj) {
        return this.mapper.updateProcessStatusStart(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="tb_tsc_process")
    public int updateProcessStatusStop(ProcessStateVo obj) {
        return this.mapper.updateProcessStatusStop(obj);
    }

    @SqlOperation(type=SqlOperation.SqlType.UPDATE, table="tb_tsc_process")
    public int updateProcessStatusRun(ProcessStateVo obj) {
        return this.mapper.updateProcessStatusRun(obj);
    }

    public TsiCommServerRepository(TsiCommServerMapper mapper) {
        this.mapper = mapper;
    }
}

