/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.dbms;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.AbstractTsiCvimProcess;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsWorker;
import com.tsi.comm.server.process.packet.TsiCvimPacketWorker;
import com.tsi.comm.server.repository.TsiNodeManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimDbmsProcess
extends AbstractTsiCvimProcess {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimDbmsProcess.class);
    private final TsiCvimServerConfig config;
    private final TsiNodeManager nodeManager;
    private ExecutorService executor = null;
    private int qSize;

    public void start() {
        ThreadGroup workerGroup = new ThreadGroup("dbmsProcess");
        this.workers = this.config.getDbmsWorkers();
        this.qSize = Math.max(10, this.nodeManager.size());
        if (this.workers == 1) {
            this.qSize *= 3;
        }
        this.executor = Executors.newFixedThreadPool(this.workers, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        for (int ii = 0; ii < this.workers; ++ii) {
            TsiCvimDbmsWorker dbmsWorker = new TsiCvimDbmsWorker(ii, this.qSize);
            this.workerList.add(dbmsWorker);
            this.executor.submit((Runnable)dbmsWorker);
        }
    }

    public boolean add(Object object, int idx) {
        boolean offer = false;
        try {
            if (idx >= 0 && idx < this.workers) {
                offer = ((AbstractTsiCvimWorker)this.workerList.get(idx)).add(object);
            } else {
                log.error("DbmsProcess: Invalid packet queue index: {}", (Object)idx);
            }
        }
        catch (Exception e) {
            log.error("DbmsProcess: QUEUE_DATA.add: Exception: {}, {}", (Object)object.toString(), (Object)e.getMessage());
        }
        return offer;
    }

    public void stop() {
        log.info("DbmsProcess Stopping...");
        for (AbstractTsiCvimWorker worker : this.workerList) {
            try {
                ((TsiCvimDbmsWorker)worker).getDATA_QUEUE().put(TsiCvimDbmsWorker.SHUTDOWN_PACKET);
            }
            catch (InterruptedException e) {
                log.warn("DbmsProcess: Interrupted while sending shutdown signal to worker {}.", (Object)worker.getIdx());
                Thread.currentThread().interrupt();
            }
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                int remainingTasks = 0;
                for (AbstractTsiCvimWorker worker : this.workerList) {
                    remainingTasks += ((TsiCvimPacketWorker)worker).getDATA_QUEUE().size();
                }
                if (remainingTasks > 0) {
                    log.warn("DbmsProcess: queue remain {}, forced shutdown.", (Object)remainingTasks);
                }
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    log.error("DbmsProcess: Executor did not terminate even after forced shutdown.");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info("DbmsProcess Stopped...");
    }

    public void report() {
        for (AbstractTsiCvimWorker worker : this.workerList) {
            worker.report();
        }
    }

    public TsiCvimServerConfig getConfig() {
        return this.config;
    }

    public TsiNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public int getQSize() {
        return this.qSize;
    }

    public TsiCvimDbmsProcess(TsiCvimServerConfig config, TsiNodeManager nodeManager) {
        this.config = config;
        this.nodeManager = nodeManager;
    }

    static /* synthetic */ int access$000(TsiCvimDbmsProcess x0) {
        return x0.workers;
    }
}

