/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.scheduler;

import com.tsi.comm.server.config.TraceConfig;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.kafka.KafkaConsumerService;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiReportManager;
import com.tsi.comm.server.repository.TsiTpmsManager;
import com.tsi.comm.server.service.TsiCommServerService;
import com.tsi.comm.server.xnet.NetUtils;
import com.tsi.common.utils.Elapsed;
import com.tsi.common.utils.TimeUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class ApplicationScheduler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationScheduler.class);
    private final TraceConfig trace;
    private final TsiCvimServerConfig config;
    private final TsiReportManager reportManager;
    private final TsiAlarmManager alarmManager;
    private final TsiTpmsManager tpmsManager;
    private final TsiCommServerService tsiCommServerService;
    private final KafkaProducerService kafkaProducerService;
    private final KafkaConsumerService kafkaConsumerService;
    private final String logFileName = "schedule";
    private String hostName;

    @PostConstruct
    void init() {
        this.hostName = NetUtils.getHostName();
    }

    @Scheduled(cron="0/5 * * * * *")
    public void staticsForPacketSecond() {
        if (!this.config.isStartup()) {
            return;
        }
        this.tpmsManager.resetSecond(this.config.getServerId(), this.hostName);
    }

    @Scheduled(cron="0/5 * * * * *")
    public void checkKafkaServerAlive() {
        if (!this.config.isStartup()) {
            return;
        }
        Elapsed elapsed = new Elapsed();
        this.kafkaConsumerService.start();
        this.kafkaProducerService.sendPing();
        if (elapsed.milliSeconds() > 500L) {
            this.getClass();
            MDC.put((String)"filename", (String)"schedule");
            log.info("{}", (Object)String.format("%25s: %s", "checkKafkaServerAlive", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
            MDC.clear();
        }
    }

    @Scheduled(cron="0/30 * * * * *")
    public void reportSystem() {
        if (!this.config.isStartup()) {
            return;
        }
        if (this.trace.isSessionReport()) {
            this.reportManager.reportNodeSessions();
        }
        this.reportManager.reportQueueInfo(this.trace.isQueueReport());
    }

    @Scheduled(cron="10 * * * * *")
    public void loadTraceInfo() {
        if (!this.config.isStartup()) {
            return;
        }
        Elapsed elapsed = new Elapsed();
        this.trace.loadTraceInfo();
        if (elapsed.milliSeconds() > 500L) {
            this.getClass();
            MDC.put((String)"filename", (String)"schedule");
            log.info("{}", (Object)String.format("%25s: %s", "loadTraceInfo", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
            MDC.clear();
        }
    }

    @Scheduled(cron="0 0/5 * * * *")
    public void loadBaseDatabase() {
        if (!this.config.isStartup()) {
            return;
        }
        Elapsed elapsed = new Elapsed();
        this.tsiCommServerService.loadDatabase();
        this.tsiCommServerService.updateProcessState(1);
        if (elapsed.milliSeconds() > 500L) {
            this.getClass();
            MDC.put((String)"filename", (String)"schedule");
            log.info("{}", (Object)String.format("%25s: %s", "loadBaseDatabase", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
            MDC.clear();
        }
    }

    public ApplicationScheduler(TraceConfig trace, TsiCvimServerConfig config, TsiReportManager reportManager, TsiAlarmManager alarmManager, TsiTpmsManager tpmsManager, TsiCommServerService tsiCommServerService, KafkaProducerService kafkaProducerService, KafkaConsumerService kafkaConsumerService) {
        this.trace = trace;
        this.config = config;
        this.reportManager = reportManager;
        this.alarmManager = alarmManager;
        this.tpmsManager = tpmsManager;
        this.tsiCommServerService = tsiCommServerService;
        this.kafkaProducerService = kafkaProducerService;
        this.kafkaConsumerService = kafkaConsumerService;
    }
}

