/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.xnet;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class NettyUtils {
    private NettyUtils() {
    }

    public static String getAddress(Channel ch) {
        InetSocketAddress remoteAddr;
        String localIp = "local-unknown";
        String remoteIp = "remote-unknown";
        int localPort = 0;
        int remotePort = 0;
        if (ch == null) {
            return "[Local #(" + localIp + ":" + localPort + ") Remote #(" + remoteIp + ":" + remotePort + ")]";
        }
        InetSocketAddress localAddr = (InetSocketAddress)ch.localAddress();
        if (localAddr != null) {
            localIp = localAddr.getAddress().getHostAddress();
            localPort = localAddr.getPort();
        }
        if ((remoteAddr = (InetSocketAddress)ch.remoteAddress()) != null) {
            remoteIp = remoteAddr.getAddress().getHostAddress();
            remotePort = remoteAddr.getPort();
        }
        return "[Local #(" + localIp + ":" + localPort + ") Remote #(" + remoteIp + ":" + remotePort + ")]";
    }

    public static String getRemoteAddress(Channel ch) {
        if (ch == null) {
            return "[Remote #(255.255.255.255:0)]";
        }
        String ip = NettyUtils.getRemoteIpAddress((Channel)ch);
        int port = NettyUtils.getRemotePort((Channel)ch);
        return "[Remote #(" + ip + ":" + port + ")]";
    }

    public static String getLocalAddress(Channel ch) {
        if (ch == null) {
            return "[Local #(255.255.255.255:0)]";
        }
        String ip = NettyUtils.getLocalIpAddress((Channel)ch);
        int port = NettyUtils.getLocalPort((Channel)ch);
        return "[Local #(" + ip + ":" + port + ")]";
    }

    public static String getRemoteIpAddress(Channel ch) {
        String ip = "255.255.255.255";
        if (ch == null) {
            return ip;
        }
        InetSocketAddress inetAddr = (InetSocketAddress)ch.remoteAddress();
        if (inetAddr != null) {
            ip = inetAddr.getAddress().getHostAddress();
        }
        return ip;
    }

    public static long getRemoteIpAddressToLong(Channel ch) {
        String[] ipAddressInArray = NettyUtils.getRemoteIpAddress((Channel)ch).split("\\.");
        long result = 0L;
        if (ch == null) {
            return result;
        }
        for (int i = 0; i < ipAddressInArray.length; ++i) {
            int power = 3 - i;
            int ip = Integer.parseInt(ipAddressInArray[i]);
            result = (long)((double)result + (double)ip * Math.pow(256.0, power));
        }
        return result;
    }

    public static int getRemotePort(Channel ch) {
        int port = 0;
        if (ch == null) {
            return port;
        }
        InetSocketAddress inetAddr = (InetSocketAddress)ch.remoteAddress();
        if (inetAddr != null) {
            port = inetAddr.getPort();
        }
        return port;
    }

    public static String getLocalIpAddress(Channel ch) {
        String ip = "127.0.0.1";
        if (ch == null) {
            return ip;
        }
        InetSocketAddress inetAddr = (InetSocketAddress)ch.localAddress();
        if (inetAddr != null) {
            ip = inetAddr.getAddress().getHostAddress();
        }
        return ip;
    }

    public static int getLocalPort(Channel ch) {
        int port = 0;
        if (ch == null) {
            return port;
        }
        InetSocketAddress inetAddr = (InetSocketAddress)ch.localAddress();
        if (inetAddr != null) {
            port = inetAddr.getPort();
        }
        return port;
    }

    public static boolean isEpollAvailable() {
        return Epoll.isAvailable();
    }

    public static EventLoopGroup newEventLoopGroup(int nThreads, String threadPoolName) {
        if (NettyUtils.isEpollAvailable()) {
            if (threadPoolName.equals("")) {
                return new EpollEventLoopGroup(nThreads);
            }
            return new EpollEventLoopGroup(nThreads, (ThreadFactory)new DefaultThreadFactory("epo" + threadPoolName));
        }
        if (threadPoolName.equals("")) {
            return new NioEventLoopGroup(nThreads);
        }
        return new NioEventLoopGroup(nThreads, (ThreadFactory)new DefaultThreadFactory("nio" + threadPoolName));
    }

    public static Class<? extends SocketChannel> getSocketChannel() {
        if (NettyUtils.isEpollAvailable()) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        if (NettyUtils.isEpollAvailable()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }
}

