/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import com.tsi.comm.server.config.TsiKafkaProducerConfig;
import com.tsi.comm.server.kafka.TsiKafkaConsumerWorker;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.stereotype.Service;

@Service
public class KafkaConsumerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerService.class);
    private final TsiKafkaProducerConfig config;
    private ConcurrentMessageListenerContainer<String, Long> kafkaListenerContainer;

    public KafkaConsumerService(TsiKafkaProducerConfig config) {
        this.config = config;
    }

    @PostConstruct
    void init() {
        log.info("[{}] ------------------", (Object)this.getClass().getSimpleName());
        this.start();
    }

    public void start() {
        if (this.kafkaListenerContainer != null) {
            if (!this.kafkaListenerContainer.isRunning()) {
                log.warn("kafkaListenerContainer restart");
                this.kafkaListenerContainer.start();
            }
            return;
        }
        ContainerProperties containerProperties = new ContainerProperties(new String[]{"cvim_ping"});
        containerProperties.setGroupId(this.config.getGroupId());
        containerProperties.setPollTimeout(5000L);
        containerProperties.setMessageListener((Object)new TsiKafkaConsumerWorker());
        containerProperties.setConsumerRebalanceListener((ConsumerRebalanceListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(this.config.getConsumerPropertiesMap());
        this.kafkaListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)consumerFactory, containerProperties);
        this.kafkaListenerContainer.setBeanName("consumer");
        this.kafkaListenerContainer.setConcurrency(1);
        this.kafkaListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("kafkaListenerContainer error: {}", (Object)thrownException.getMessage());
            this.kafkaListenerContainer.stop();
        });
        this.kafkaListenerContainer.start();
    }

    public void shutdown() {
        try {
            if (this.kafkaListenerContainer != null) {
                this.kafkaListenerContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

