/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.mybatis;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.comm.server.mybatis.TsiDatabaseMapper;
import com.tsi.comm.server.mybatis.vo.AlarmConfigVo;
import com.tsi.comm.server.mybatis.vo.AlarmOccrVo;
import com.tsi.comm.server.mybatis.vo.NodeAddDetailVo;
import com.tsi.comm.server.mybatis.vo.NodeAddVo;
import com.tsi.comm.server.mybatis.vo.NodeVo;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeAddManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TsiDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(TsiDatabaseService.class);
    private TsiDatabaseMapper tsiDatabaseMapper;

    @PostConstruct
    void init() {
        this.tsiDatabaseMapper = (TsiDatabaseMapper)AppUtils.getBean(TsiDatabaseMapper.class);
        this.initDatabase();
        this.loadDatabase();
    }

    public void loadAlarmConfig() {
        String TAG = "loadAlarmConfig";
        long startTime = System.nanoTime();
        List objLists = this.tsiDatabaseMapper.getAlarmConfig();
        for (AlarmConfigVo obj : objLists) {
            TsiAlarmConfigVo alarm = TsiAlarmManager.getInstance().get(obj.getAlarmCode());
            if (alarm != null) {
                alarm.setDesc(obj.getDesc());
                alarm.setValue(obj.getValue());
                alarm.setUseYn(obj.getUseYn().equals("Y"));
                continue;
            }
            alarm = new TsiAlarmConfigVo();
            alarm.setAlarmCode(obj.getAlarmCode());
            alarm.setDesc(obj.getDesc());
            alarm.setValue(obj.getValue());
            alarm.setUseYn(obj.getUseYn().equals("Y"));
            TsiAlarmManager.getInstance().put(obj.getAlarmCode(), alarm);
        }
        log.info("{}: ..end. {}/{} EA. {}", new Object[]{TAG, objLists.size(), TsiAlarmManager.getInstance().size(), TimeUtils.elapsedTime((long)startTime)});
    }

    public void initDatabase() {
        int result = this.tsiDatabaseMapper.insertNodeStatusInitialize();
        this.updateNodeStatusTerm();
        log.info("init database: {} EA", (Object)result);
    }

    public void loadDatabase() {
        this.loadTsiNode();
        this.loadTsiNodeAdd();
        this.loadAlarmConfig();
    }

    private void loadTsiNode() {
        String TAG = "loadTsiNode";
        long startTime = System.nanoTime();
        TsiNodeManager.getInstance().beforeLoading();
        List objLists = this.tsiDatabaseMapper.getNodeInfoList();
        for (NodeVo obj : objLists) {
            boolean installed = obj.getUseYn().equals("Y");
            TsiNodeVo node = TsiNodeManager.getInstance().get(obj.getNodeId().longValue());
            if (node != null) {
                node.setCheckInstalled(installed);
                node.setSendTest(obj.getTestYn().equals("Y"));
                node.setSendNode(obj.getNodeYn().equals("Y"));
                node.setSendCvim(obj.getCvimYn().equals("Y"));
                node.setRegistered(true);
                continue;
            }
            node = new TsiNodeVo(obj.getNodeId().longValue(), obj.getTestYn().equals("Y"), obj.getNodeYn().equals("Y"), obj.getCvimYn().equals("Y"));
            node.setRegistered(true);
            node.setCheckInstalled(installed);
            TsiNodeManager.getInstance().put(obj.getNodeId().longValue(), node);
        }
        TsiNodeManager.getInstance().afterLoading();
        log.info("{}: ..end. {}/{} EA. {}", new Object[]{TAG, objLists.size(), TsiNodeManager.getInstance().size(), TimeUtils.elapsedTime((long)startTime)});
    }

    private void loadTsiNodeAdd() {
        String TAG = "loadTsiNodeAdd";
        long startTime = System.nanoTime();
        List objLists = this.tsiDatabaseMapper.getNodeAddInfoList();
        for (NodeAddVo obj : objLists) {
            long originNodeId = obj.getOriginNodeId();
            TsiNodeVo orgTsiNodeVo = TsiNodeManager.getInstance().get(originNodeId);
            if (orgTsiNodeVo == null) {
                log.error("Not found origin_node_id: {}", (Object)originNodeId);
                orgTsiNodeVo = new TsiNodeVo(originNodeId, true, true, true);
                orgTsiNodeVo.setCheckInstalled(true);
                orgTsiNodeVo.setRegistered(false);
                orgTsiNodeVo.setAddNodeEnabled(true);
                TsiNodeManager.getInstance().put(originNodeId, orgTsiNodeVo);
            } else {
                orgTsiNodeVo.setAddNodeEnabled(true);
            }
            TsiNodeAddVo tsiNodeAddVo = new TsiNodeAddVo();
            tsiNodeAddVo.setOriginNodeId(originNodeId);
            for (int ii = 0; ii < obj.getAddDetailList().size(); ++ii) {
                NodeAddDetailVo nodeAddDetailVo = (NodeAddDetailVo)obj.getAddDetailList().get(ii);
                Long nodeId = nodeAddDetailVo.getNodeId();
                TsiNodeAddDetailVo tsiNodeAddDetailVo = new TsiNodeAddDetailVo();
                TsiNodeVo addNodeVo = TsiNodeManager.getInstance().get(nodeId.longValue());
                if (addNodeVo == null) {
                    log.error("Not found add_node_id: {}", (Object)nodeId);
                    addNodeVo = new TsiNodeVo(originNodeId, orgTsiNodeVo.isSendTest(), orgTsiNodeVo.isSendNode(), orgTsiNodeVo.isSendCvim());
                    addNodeVo.setCheckInstalled(true);
                    addNodeVo.setRegistered(false);
                    TsiNodeManager.getInstance().put(nodeId.longValue(), addNodeVo);
                }
                tsiNodeAddDetailVo.setNodeId(nodeId.longValue());
                tsiNodeAddDetailVo.setOriginDirCode(nodeAddDetailVo.getOriginDirCode());
                tsiNodeAddDetailVo.setAddNodeOrder(nodeAddDetailVo.getAddNodeOrder());
                tsiNodeAddDetailVo.setAddDirCode(nodeAddDetailVo.getAddDirCode());
                tsiNodeAddDetailVo.setNodeObj(addNodeVo);
                tsiNodeAddVo.getAddNodeMap().put(tsiNodeAddDetailVo.getOriginDirCode() * 1000 + tsiNodeAddDetailVo.getAddNodeOrder(), tsiNodeAddDetailVo);
                if (tsiNodeAddDetailVo.getNodeObj() == null) continue;
            }
            orgTsiNodeVo.setTsiNodeAddVo(tsiNodeAddVo);
            TsiNodeAddManager.getInstance().put(tsiNodeAddVo.getOriginNodeId(), tsiNodeAddVo);
        }
        log.info("{}: ..end. {} EA. {}", new Object[]{TAG, TsiNodeAddManager.getInstance().size(), TimeUtils.elapsedTime((long)startTime)});
    }

    public void updateNodeStatusTerm() {
        int result = this.tsiDatabaseMapper.updateNodeStatusTerm();
        log.info("update node status term: {} EA", (Object)result);
    }

    public int insertAlarmOccrHs(AlarmOccrVo vo) {
        int res = 0;
        try {
            res = this.tsiDatabaseMapper.insertAlarmOccrHs(vo);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        return res;
    }

    public int updateProcessState(int flag) {
        int res = 0;
        try {
            res = flag == 0 ? this.tsiDatabaseMapper.updateProcessStatusStart(TsiAlarmManager.getInstance().getProcessStateVo()) : (flag == 1 ? this.tsiDatabaseMapper.updateProcessStatusRun(TsiAlarmManager.getInstance().getProcessStateVo()) : this.tsiDatabaseMapper.updateProcessStatusStop(TsiAlarmManager.getInstance().getProcessStateVo()));
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        return res;
    }

    public TsiDatabaseMapper getTsiDatabaseMapper() {
        return this.tsiDatabaseMapper;
    }

    public void setTsiDatabaseMapper(TsiDatabaseMapper tsiDatabaseMapper) {
        this.tsiDatabaseMapper = tsiDatabaseMapper;
    }
}

