/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.dbms;

import com.tsi.app.common.app.AppUtils;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.AbstractTsiCvimProcess;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsWorker;
import com.tsi.comm.server.repository.TsiNodeManager;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimDbmsProcess
extends AbstractTsiCvimProcess {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimDbmsProcess.class);

    @PostConstruct
    void init() {
        int qSize;
        int nodes;
        ThreadGroup workerGroup = new ThreadGroup("dbmsProcess");
        TsiCvimServerConfig tsiCvimServerConfig = (TsiCvimServerConfig)AppUtils.getBean(TsiCvimServerConfig.class);
        this.workers = tsiCvimServerConfig.getDbmsWorkers();
        if (this.workers <= 0) {
            this.workers = 1;
        }
        if ((nodes = TsiNodeManager.getInstance().size()) > (qSize = tsiCvimServerConfig.getQueueSize())) {
            qSize = nodes;
        }
        qSize *= 4;
        qSize /= this.workers;
        qSize = 1000;
        for (int ii = 0; ii < this.workers; ++ii) {
            TsiCvimDbmsWorker dbmsWorker = new TsiCvimDbmsWorker(ii, qSize);
            this.workerList.add(dbmsWorker);
            Thread worker = new Thread(workerGroup, (Runnable)dbmsWorker);
            worker.setName(String.format("dbsWorker-%02d.%02d", this.workers, ii + 1));
            worker.setDaemon(true);
            this.threadList.add(worker);
        }
        for (Thread worker : this.threadList) {
            worker.start();
        }
    }

    public boolean add(Object object, int idx) {
        boolean offer = false;
        try {
            offer = ((AbstractTsiCvimWorker)this.workerList.get(idx %= this.workers)).add(object);
        }
        catch (Exception e) {
            log.error("QUEUE_DATA.add: Exception: {}, {}", (Object)object.toString(), (Object)e.getMessage());
        }
        return offer;
    }

    public void stop() {
    }

    public void report() {
        for (AbstractTsiCvimWorker worker : this.workerList) {
            worker.report();
        }
    }
}

