/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.logging;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.comm.server.mongo.dto.TcsNodeStatus;
import com.tsi.comm.server.mongo.repository.TsiNodeStatusRepository;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TsiCvimLoggingWorker
extends AbstractTsiCvimWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimLoggingWorker.class);
    private final LinkedBlockingQueue<AbstractTsiPacket> DATA_QUEUE;
    private TsiNodeStatusRepository tsiNodeStatusRepository;

    public TsiCvimLoggingWorker(int idx, int qSize) {
        this.idx = idx;
        this.qSize = qSize;
        this.DATA_QUEUE = new LinkedBlockingQueue(qSize);
        try {
            this.tsiNodeStatusRepository = (TsiNodeStatusRepository)AppUtils.getBean(TsiNodeStatusRepository.class);
        }
        catch (Exception e) {
            this.tsiNodeStatusRepository = null;
            log.error("MongoDB: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void run() {
        log.info("{} Start. QSIZE: {}", (Object)Thread.currentThread().getName(), (Object)this.qSize);
        while (true) {
            try {
                while (true) {
                    AbstractTsiPacket packet;
                    if ((packet = (AbstractTsiPacket)this.DATA_QUEUE.take()) == null) {
                        continue;
                    }
                    this.process((Object)packet);
                }
            }
            catch (Exception e) {
                log.error("Exception: {}", (Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public boolean add(Object object) {
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            offer = this.DATA_QUEUE.offer(packet);
            if (!offer) {
                MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
                log.error("Logging Queue.offer: {}/{}, Queue Full: {} EA, {}, {}", new Object[]{packet.getNodeId(), this.DATA_QUEUE.size(), this.qSize, TimeUtils.elapsedTime((long)packet.getRcv()), Thread.currentThread().getName()});
                MDC.clear();
            }
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("Logging Queue.offer: Exception: {}, {}, {}", new Object[]{packet.getNodeId(), Thread.currentThread().getName(), e.getMessage()});
            MDC.clear();
        }
        return offer;
    }

    public void process(Object object) {
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        long add = packet.getAdd() - packet.getRcv();
        long pop = packet.getPop() - packet.getAdd();
        long par = packet.getPar() - packet.getPop();
        long kaf = packet.getEnd() - packet.getPar();
        long mongo = 0L;
        long jobTotal = 0L;
        long job = packet.getEnd() - packet.getRcv();
        Date date = new Date(packet.getTimespec().times() * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        String collectTime = sdf.format(date);
        if (this.tsiNodeStatusRepository != null && packet instanceof TsiCpuPacket) {
            try {
                long start = System.nanoTime();
                TsiCpuPacket cpuPacket = (TsiCpuPacket)packet;
                TcsNodeStatus mongoStatus = cpuPacket.getNodeStatus();
                if (mongoStatus != null) {
                    this.tsiNodeStatusRepository.save((Object)mongoStatus);
                    mongo = System.nanoTime() - start;
                    packet.setEnd(System.nanoTime());
                    jobTotal = packet.getEnd() - packet.getRcv();
                }
            }
            catch (Exception e) {
                log.error("Node: {}, MongoDB parsing error.", (Object)packet.getNodeId());
            }
        }
        MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
        log.info("{} Node: {}, {}: {} {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "Q-Add"), TimeUtils.elapsedTimeStr((long)add), Thread.currentThread().getName()});
        log.info("{} Node: {}, {}: {} {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "Q-Pop"), TimeUtils.elapsedTimeStr((long)pop), Thread.currentThread().getName()});
        log.info("{} Node: {}, {}: {} {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "Parsing"), TimeUtils.elapsedTimeStr((long)par), Thread.currentThread().getName()});
        log.info("{} Node: {}, {}: {} {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "Kafka"), TimeUtils.elapsedTimeStr((long)kaf), Thread.currentThread().getName()});
        log.info("{} Node: {}, {}: {} {}, {} bytes, Average {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "Job"), TimeUtils.elapsedTimeStr((long)job), Thread.currentThread().getName(), packet.getPacketLength(), TimeUtils.elapsedTimeStr((long)packet.getAvg())});
        if (mongo > 0L) {
            log.info("{} Node: {}, {}: {} {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "MongoDb"), TimeUtils.elapsedTimeStr((long)mongo), Thread.currentThread().getName()});
            log.info("{} Node: {}, {}: {} {}", new Object[]{collectTime, packet.getNodeId(), String.format("%10s", "Total Job"), TimeUtils.elapsedTimeStr((long)jobTotal), Thread.currentThread().getName()});
        }
        log.info("{} Node: {}, ====", (Object)collectTime, (Object)packet.getNodeId());
        MDC.clear();
    }

    public void report() {
        log.info("Logging: Remain Q: {}, Average {}, {}", new Object[]{this.DATA_QUEUE.size(), TimeUtils.elapsedTimeStr((long)this.avgTime), Thread.currentThread().getName()});
    }
}

