/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.OS;
import com.tsi.app.common.xnet.NettyServerConfig;
import com.tsi.app.common.xnet.NettyTcpServer;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.tcp.codec.CvimServerByteBufMessageDecoder;
import com.tsi.comm.server.tcp.codec.CvimServerEncoder;
import com.tsi.comm.server.tcp.handler.CvimServerInboundMessageHandler;
import com.tsi.comm.server.tcp.initializer.CvimServerInitializer;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.epoll.Epoll;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimServer
extends NettyTcpServer {
    private final TsiCvimServerConfig config;
    private CvimServerByteBufMessageDecoder cvimServerByteBufMessageDecoder;
    private CvimServerInboundMessageHandler cvimServerInboundMessageHandler;
    private CvimServerEncoder cvimServerEncoder;

    public TsiCvimServer(TsiCvimServerConfig config) {
        super((NettyServerConfig)config);
        this.config = config;
        this.cvimServerByteBufMessageDecoder = (CvimServerByteBufMessageDecoder)AppUtils.getBean(CvimServerByteBufMessageDecoder.class);
        this.cvimServerInboundMessageHandler = (CvimServerInboundMessageHandler)AppUtils.getBean(CvimServerInboundMessageHandler.class);
        this.cvimServerEncoder = (CvimServerEncoder)AppUtils.getBean(CvimServerEncoder.class);
    }

    @PostConstruct
    public void initialize() {
        super.setChannelInitializer((ChannelInitializer)new CvimServerInitializer(this.config));
        if (!OS.isWindows() && !Epoll.isAvailable()) {
            Epoll.unavailabilityCause().printStackTrace();
        }
        if (NettyUtils.isEpollAvailable()) {
            System.out.println("\uc11c\ubc84\uac00 \ub9ac\ub205\uc2a4 EPOLL \ubaa8\ub4dc\uc5d0\uc11c \uc2e4\ud589\ub429\ub2c8\ub2e4.");
        } else {
            System.out.println("\uc11c\ubc84\uac00 \uc708\ub3c4\uc6b0 NIO \ubaa8\ub4dc\uc5d0\uc11c \uc2e4\ud589\ub429\ub2c8\ub2e4.");
        }
    }
}

